<?php

class WPSocialLinksModel extends ObjectModel
{
    public $id_wpsociallinks;
    public $active = 1;
    public $position;
    public $icon;
    public $custom_icon;
    public $link;
    public $open_in_new;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'wpsociallinks',
        'primary' => 'id_wpsociallinks',
        'multilang' => false,
        'fields' => array(
            //Fields
            'active'          =>  array('type' => self::TYPE_INT, 'validate' => 'isBool'),
            'position'        =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'icon'            =>  array('type' => self::TYPE_STRING),
            'custom_icon'     =>  array('type' => self::TYPE_STRING),
            'link'            =>  array('type' => self::TYPE_STRING, 'validate' => 'isUrl', 'required' => true, 'size' => 250),
            'open_in_new'     =>  array('type' => self::TYPE_INT, 'validate' => 'isBool')
        )
    );

    /*-------------------------------------------------------------*/
    /*  CONSTRUCT
    /*-------------------------------------------------------------*/
    public function __construct($id_wpsociallinks = null, $id_lang = null, $id_shop = null)
    {
        Shop::addTableAssociation('wpsociallinks', array('type' => 'shop'));
        parent::__construct($id_wpsociallinks, $id_lang, $id_shop);
    }

    /*-------------------------------------------------------------*/
    /*  ADD
    /*-------------------------------------------------------------*/
    public function add($autoddate = true, $null_values = false)
    {
        $this->position = (int) $this->getMaxPosition() + 1;
        return parent::add();
    }

    /*-------------------------------------------------------------*/
    /*  DELETE
    /*-------------------------------------------------------------*/
    public function delete()
    {
        $response = parent::delete();
        $this->deleteImg();
        $this->reorderLinks();

        return $response;
    }

    /*-------------------------------------------------------------*/
    /*  DELETE IMAGE
    /*-------------------------------------------------------------*/
    public function deleteImg()
    {
        if (!$this->id) {
            return false;
        }

        if (file_exists(_PS_MODULE_DIR_ . 'wpsociallinks/views/img/front/customIcons/' . $this->custom_icon)){
            unlink(_PS_MODULE_DIR_ . 'wpsociallinks/views/img/front/customIcons/' . $this->custom_icon);
        }

    }

    /*-------------------------------------------------------------*/
    /*  GET LINK IDs
    /*-------------------------------------------------------------*/
    public function getLinkIds($id_shop)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT a.id_wpsociallinks, b.id_wpsociallinks
            FROM '._DB_PREFIX_.'wpsociallinks as a,
                 '._DB_PREFIX_.'wpsociallinks_shop as b
            WHERE a.id_wpsociallinks = b.id_wpsociallinks
            AND b.id_shop = '.$id_shop.'
            AND a.active = 1
            ORDER BY a.position ASC'
        );

        return $response;
    }

    /*-------------------------------------------------------------*/
    /*  GET MAX POSITION
    /*-------------------------------------------------------------*/
    public static function getMaxPosition()
    {
        $response = Db::getInstance()->getRow('
            SELECT MAX(position)
			FROM `'._DB_PREFIX_.'wpsociallinks`'
        );

        if ($response['MAX(position)'] == null){
            return -1;
        }

        return $response['MAX(position)'];

    }

    /*-------------------------------------------------------------*/
    /*  UPDATE POSITION
    /*-------------------------------------------------------------*/
    public function updatePosition($way, $position)
    {
        if (!$links = Db::getInstance()->executeS('
			SELECT `id_wpsociallinks`, `position`
			FROM `'._DB_PREFIX_.'wpsociallinks`
			ORDER BY `position` ASC'
        ))
            return false;

        foreach ($links as $link)
            if ((int)$link['id_wpsociallinks'] == (int)$this->id)
                $moved_link = $link;

        if (!isset($moved_link) || !isset($position))
            return false;

        return (Db::getInstance()->execute('
			UPDATE `'._DB_PREFIX_.'wpsociallinks`
			SET `position`= `position` '.($way ? '- 1' : '+ 1').'
			WHERE `position`
			'.($way
                       ? '> '.(int)$moved_link['position'].' AND `position` <= '.(int)$position
                       : '< '.(int)$moved_link['position'].' AND `position` >= '.(int)$position
			))
            && Db::getInstance()->execute('
			UPDATE `'._DB_PREFIX_.'wpsociallinks`
			SET `position` = '.(int)$position.'
			WHERE `id_wpsociallinks` = '.(int)$moved_link['id_wpsociallinks']));
    }

    /*-------------------------------------------------------------*/
    /*  REORDER LINKS AFTER DELETION
    /*-------------------------------------------------------------*/
    public static function reorderLinks()
    {
        $return = true;

        $sql = 'SELECT `id_wpsociallinks`
		        FROM `'._DB_PREFIX_.'wpsociallinks`
		        ORDER BY `position` ASC';

        $result = Db::getInstance()->executeS($sql);

        $i = 0;
        foreach ($result as $value) {
            $return = Db::getInstance()->execute('
			UPDATE `'._DB_PREFIX_.'wpsociallinks`
			SET `position` = '.(int)$i++.'
			WHERE `id_wpsociallinks` = '.(int)$value['id_wpsociallinks']);
        }

        return $return;
    }
}