<?php
/*
    * Based on Wordpress Shortcodes API
    * Copyright (c) 2003-2014 Wordpress
    * Licensed under the GPLv2 (or later)
    * http://www.wordpress.org/
    * All rights reserved
*/
class WPSmartCodesProcessor
{

    private static $instance;
    private $_tagNames;

    private function __construct()
    {
        $this->_tagNames = array(
            'row',
            'column',
            'button',
            'icon'
        );
    }

    public static function getInstance()
    {
        if (!isset(self::$instance)){
            self::$instance = new WPSmartCodesProcessor;
        }

        return WPSmartCodesProcessor::$instance;
    }

    public static function wpProcessSmartCodes($params)
    {
        $self = WPSmartCodesProcessor::getInstance();

        if (!isset($params['content']) || !$params['content']){
            return false;
        }

        if ( false === strpos( $params['content'], '[' ) ) {
		    return $params['content'];
	    }

        $pattern = $self->getRegexPattern();

    	return preg_replace_callback('/' . $pattern . '/s', array($self, 'doSmartCode'), $params['content']);
    }

    public function getRegexPattern()
    {
        $tags = join( '|', array_map('preg_quote', $this->_tagNames) );

        // WARNING! Do not change this regex
        return
              '\\['                              // Opening bracket
            . '(\\[?)'                           // 1: Optional second opening bracket for escaping shortcodes: [[tag]]
            . "($tags)"                          // 2: Shortcode name
            . '(?![\\w-])'                       // Not followed by word character or hyphen
            . '('                                // 3: Unroll the loop: Inside the opening shortcode tag
            .     '[^\\]\\/]*'                   // Not a closing bracket or forward slash
            .     '(?:'
            .         '\\/(?!\\])'               // A forward slash not followed by a closing bracket
            .         '[^\\]\\/]*'               // Not a closing bracket or forward slash
            .     ')*?'
            . ')'
            . '(?:'
            .     '(\\/)'                        // 4: Self closing tag ...
            .     '\\]'                          // ... and closing bracket
            . '|'
            .     '\\]'                          // Closing bracket
            .     '(?:'
            .         '('                        // 5: Unroll the loop: Optionally, anything between the opening and closing shortcode tags
            .             '[^\\[]*+'             // Not an opening bracket
            .             '(?:'
            .                 '\\[(?!\\/\\2\\])' // An opening bracket not followed by the closing shortcode tag
            .                 '[^\\[]*+'         // Not an opening bracket
            .             ')*+'
            .         ')'
            .         '\\[\\/\\2\\]'             // Closing shortcode tag
            .     ')?'
            . ')'
            . '(\\]?)';                          // 6: Optional second closing brocket for escaping shortcodes: [[tag]]
    }


    private function doSmartCode($match)
    {
        // Allow [[tag]] escape
        if ( $match[1] == '[' && $match[6] == ']' ) {
            return substr($match[0], 1, -1);
        }

        $tag = $match[2];
        $attributes = $this->parseSmartCodeAttributes($match[3]);

        if (isset($match[5]))
        {
            // Enclosing smart code tag
            $WPSmartCodesRenderer = new WPSmartCodesRenderer($match[5]);
            return $match[1] . call_user_func(array($WPSmartCodesRenderer, $tag), $attributes) . $match[6];
        }
        else
        {
            // Self closing smart code tag
            $WPSmartCodesRenderer = new WPSmartCodesRenderer();
            return $match[1] . call_user_func(array($WPSmartCodesRenderer, $tag), $attributes) . $match[6];
        }
    }


    private function parseSmartCodeAttributes($context)
    {
        $attr = array();
        $pattern = '/(\w+)\s*=\s*"([^"]*)"(?:\s|$)|(\w+)\s*=\s*\'([^\']*)\'(?:\s|$)|(\w+)\s*=\s*([^\s\'"]+)(?:\s|$)|"([^"]*)"(?:\s|$)|(\S+)(?:\s|$)/';
        $context = preg_replace("/[\x{00a0}\x{200b}]+/u", " ", $context);

        if (preg_match_all($pattern, $context, $matches, PREG_SET_ORDER)) {
            foreach ($matches as $match)
            {
                if (!empty($match[1])){
                    $attr[strtolower($match[1])] = stripcslashes($match[2]);
                }
                elseif (!empty($match[3])){
                    $attr[strtolower($match[3])] = stripcslashes($match[4]);
                }
                elseif (!empty($match[5])){
                    $attr[strtolower($match[5])] = stripcslashes($match[6]);
                }
                elseif (isset($match[7]) and strlen($match[7])){
                    $attr[] = stripcslashes($match[7]);
                }
                elseif (isset($match[8])){
                    $attr[] = stripcslashes($match[8]);
                }
            }
        } else {
            $attr = ltrim($context);
        }

        return $attr;
    }
} 