{if $wpproductcarousels.carousels}

    <div id="wpproductcarousels" class="row parent">

        {foreach $wpproductcarousels.carousels as $carousel}

            {if ($carousel.products)}
                <div class="wpproductcarousel">
                    <div class="row">
                        <div class="column col-12-12 title-1">
                            {$carousel.title}
                        </div>
                    </div>

                    <div class="row">
                        <div class="column col-12-12">
                            <div class="wpproductcarousel-carousel grid carousel-grid owl-carousel">

                                {foreach $carousel.products as $product}

                                    {if $product}
                                        <div class="item">
                                            <div class="item-wrapper">

                                                <div class="item-upper-container">
                                                    <div class="item-image-container white-border-3px">
                                                        {if ( (isset($product.new) && $product.new == 1) || (isset($product.on_sale) && $product.on_sale) || (isset($product.reduction) && $product.reduction) || (isset($product.online_only) && $product.online_only) )}
                                                            <div class="item-tag">
                                                                {if isset($product.new) && $product.new == 1}
                                                                    <span class="item-tag-new">{l s='New' mod='wpproductcarousels'}</span>
                                                                {/if}

                                                                {if isset($product.on_sale) && $product.on_sale && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}
                                                                    {if (isset($product.specific_prices) && $product.specific_prices && isset($product.specific_prices.reduction) && $product.specific_prices.reduction > 0 )}
                                                                        <span class="item-tag-discount">
                                                                            {if ($product.specific_prices.reduction_type == 'amount')}
                                                                                <span>-{displayWtPrice p=$product.specific_prices.reduction}</span>
                                                                            {elseif ($product.specific_prices.reduction_type == 'percentage')}
                                                                                <span>-{$product.specific_prices.reduction * 100}%</span>
                                                                            {/if}
                                                                        </span>
                                                                    {/if}
                                                                {elseif isset($product.reduction) && $product.reduction && isset($product.show_price) && $product.show_price && !$PS_CATALOG_MODE}
                                                                    <span class="item-tag-discount">{l s='Discount!' mod='wpproductcarousels'}</span>
                                                                {/if}

                                                                {if (!$PS_CATALOG_MODE AND ((isset($product.show_price) && $product.show_price) || (isset($product.available_for_order) && $product.available_for_order)))}
                                                                    {if isset($product.online_only) && $product.online_only}
                                                                        <span class="item-online-only">{l s='Online only' mod='wpproductcarousels'}</span>
                                                                    {/if}
                                                                {/if}
                                                            </div>
                                                        {/if}

                                                        {if isset($WPAC_enableCountdownTimer) && $WPAC_enableCountdownTimer && isset($product.specific_prices.to) && $product.specific_prices.to != '0000-00-00 00:00:00'}
                                                            <span class="item-countdown">
                                                                <span class="item-countdown-label">{l s='Limited offer ends in:' mod='wpproductcarousels'}</span>
                                                                <span class="item-countdown-time" data-time="{$product.specific_prices.to}"></span>
                                                            </span>
                                                        {/if}

                                                        <a href="{$product.link|escape:'html'}" class="item-image-link" title="{$product.name|escape:html:'UTF-8'}">
                                                            <img class="item-image item-image-cover replace-retina" src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'atmn_normal')|escape:'html'}" alt="{$product.name|escape:html:'UTF-8'}"/>
                                                        </a>
                                                    </div>
                                                </div>

                                                <div class="item-details">
                                                    <a href="{$product.link|escape:'html'}" class="item-name-link" title="{$product.name|escape:html:'UTF-8'}">
                                                        <span class="item-name">{$product.name|escape:html:'UTF-8'}</span>
                                                    </a>

                                                    {if $wpproductcarousels.showPrice && $product.show_price && !isset($restricted_country_mode) && !$PS_CATALOG_MODE}
                                                        <span class="item-price">
                                                            {if !$priceDisplay}{convertPrice price=$product.price}{else}{convertPrice price=$product.price_tax_exc}{/if}
                                                            {if isset($product.specific_prices) && $product.specific_prices && isset($product.specific_prices.reduction) && $product.specific_prices.reduction > 0}
                                                                <span class="item-old-price">
                                                                    {displayWtPrice p=$product.price_without_reduction}
                                                                </span>
                                                            {/if}
                                                        </span>
                                                    {/if}

                                                    {if $wpproductcarousels.showCartBtn}
                                                        <div class="item-buttons">
                                                            {if ($product.id_product_attribute == 0 || (isset($add_prod_display) && ($add_prod_display == 1))) && $product.available_for_order && !isset($restricted_country_mode) && $product.minimal_quantity == 1 && $product.customizable != 2 && !$PS_CATALOG_MODE}
                                                                {if ($product.allow_oosp || $product.quantity > 0)}
                                                                    <a class="ajax_add_to_cart_button button-2 fill add-to-cart" href="{$link->getPageLink('cart')|escape:'html'}?qty=1&amp;id_product={$product.id_product|intval}&amp;token={$static_token}&amp;add" title="{l s='Add to cart' mod='wpproductcarousels'}" data-id-product="{$product.id_product|intval}">
                                                                        <span class="wpicon wpicon-cart medium"></span><span>{l s='Add to cart' mod='wpproductcarousels'}</span>
                                                                    </a>
                                                                {else}
                                                                    <a class="button-2 fill view_product_button view-product" href="{$product.link|escape:'html'}" title="{l s='View Product' mod='wpproductcarousels'}">
                                                                        <span class="wpicon wpicon-eye2 medium"></span><span>{l s='View Product' mod='wpproductcarousels'}</span>
                                                                    </a>
                                                                {/if}
                                                            {/if}
                                                        </div>
                                                    {/if}
                                                </div>

                                            </div>
                                        </div>
                                    {/if}

                                {/foreach}

                            </div>
                        </div>
                    </div>
                </div>
            {/if}

        {/foreach}

    </div>

    {if ($wpproductcarousels.autoScroll)}
        {addJsDef wppc_autoscroll=$wpproductcarousels.autoScrollDelay}
    {else}
        {addJsDef wppc_autoscroll=false}
    {/if}

    {if ($wpproductcarousels.pauseOnHover)}
        {addJsDef wppc_pauseonhover=true}
    {else}
        {addJsDef wppc_pauseonhover=false}
    {/if}

{/if}