{if isset($wpblogcustomblockb) && $wpblogcustomblockb}
    <div id="wpblogcustomblockb-sidebar" class="block">
        {if isset($wpblogcustomblockb.title) && $wpblogcustomblockb.title}
            <h4>{$wpblogcustomblockb.title}</h4>
        {/if}

        {if isset($wpblogcustomblockb.posts) && $wpblogcustomblockb.posts}
            <ul id="wpblogcustomblockb-posts">
                {foreach $wpblogcustomblockb.posts as $post}
                    <li class="clearfix">
                        {if (isset($post.featuredImage) && $post.featuredImage)}
                            <a class="post-image" href="{$post.link}">
                                <img class="white-border-3px" src="{$wpblogcustomblockb.blogImageDir}{$post.featuredImage}-smallsqr.jpg">
                            </a>
                        {elseif (isset($post.video_embed) && $post.video_embed)}
                            <a class="post-image" href="{$post.link}">
                                <img class="white-border-3px" src="{$wpblogcustomblockb.blogImageDir}videoplaceholder-xsmallsqr.jpg">
                            </a>
                        {/if}
                        <div class="post-details">
                            <span class="post-name">
                                <a href="{$post.link}">{$post.name|truncate:65:'...'|escape:'UTF-8'}</a>
                            </span>
                            <span class="post-published">
                                {$post.published_on}
                            </span>
                        </div>
                    </li>
                {/foreach}
            </ul>

        {else}
            {l s='There are no posts to show!' mod='wpblogcustomblockb'}
        {/if}
    </div>
{/if}