{if isset($wpblogcustomblocka) && $wpblogcustomblocka}
    <div id="wpblogcustomblocka-sidebar" class="block">
        {if isset($wpblogcustomblocka.title) && $wpblogcustomblocka.title}
            <h4>{$wpblogcustomblocka.title}</h4>
        {/if}

        {if isset($wpblogcustomblocka.posts) && $wpblogcustomblocka.posts}
            <ul id="wpblogcustomblocka-posts">
                {foreach $wpblogcustomblocka.posts as $post}
                    <li class="clearfix">
                        {if (isset($post.featuredImage) && $post.featuredImage)}
                            <a class="post-image" href="{$post.link}">
                                <img class="white-border-3px" src="{$wpblogcustomblocka.blogImageDir}{$post.featuredImage}-smallsqr.jpg">
                            </a>
                        {elseif (isset($post.video_embed) && $post.video_embed)}
                            <a class="post-image" href="{$post.link}">
                                <img class="white-border-3px" src="{$wpblogcustomblocka.blogImageDir}videoplaceholder-xsmallsqr.jpg">
                            </a>
                        {/if}
                        <div class="post-details">
                            <span class="post-name">
                                <a href="{$post.link}">{$post.name|truncate:65:'...'|escape:'UTF-8'}</a>
                            </span>
                            <span class="post-published">
                                {$post.published_on}
                            </span>
                        </div>
                    </li>
                {/foreach}
            </ul>

        {else}
            {l s='There are no posts to show!' mod='wpblogcustomblocka'}
        {/if}
    </div>
{/if}

