<?php

/* Withinpixels - Blog Module - 2014 - Sercan YEMEN - twitter.com/sercan */

if (!defined('_PS_VERSION_'))
    exit;

include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogCategoryModel.php');
include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogCommentModel.php');
include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostModel.php');
include_once(_PS_MODULE_DIR_ . 'wpblog/models/wpBlogPostRelationModel.php');

class WPBlog extends Module {

    private $_output = '';
    
    /* ------------------------------------------------------------- */
    /*  ROUTE ARRAY FOR BLOG PAGES
    /* ------------------------------------------------------------- */
    public static $moduleRoute = array(
        'module-wpblog-blog' => array(
            'controller' =>  'blog',
            'rule' =>        'blog',
            'keywords' => array(),
            'params' => array(
                'fc' => 'module',
                'module' => 'wpblog'
            )
        ),
        'module-wpblog-category' => array(
            'controller' =>  'category',
            'rule' =>        'blog/{id_wpblog_cats}-{rewrite}',
            'keywords' => array(
                'id_wpblog_cats' =>   array('regexp' => '[0-9]+', 'param' => 'id_wpblog_cats'),
                'rewrite'        =>   array('regexp' => '[_a-zA-Z0-9-\pL]*', 'param' => 'rewrite')
            ),
            'params' => array(
                'fc' => 'module',
                'module' => 'wpblog'
            )
        ),
        'module-wpblog-post' => array(
            'controller' =>  'post',
            'rule' =>        'blog/post/{id_wpblog_posts}-{rewrite}',
            'keywords' => array(
                'id_wpblog_posts' =>   array('regexp' => '[0-9]+', 'param' => 'id_wpblog_posts'),
                'rewrite'         =>   array('regexp' => '[_a-zA-Z0-9-\pL]*', 'param' => 'rewrite'),
            ),
            'params' => array(
                'fc' => 'module',
                'module' => 'wpblog'
            )
        ),
        'module-wpblog-archive' => array(
            'controller' =>  'archive',
            'rule' =>        'blog/{year}{/:month}',
            'keywords' => array(
                'year'  =>   array('regexp' => '[1-9][0-9][0-9][0-9]', 'param' => 'year'),
                'month' =>   array('regexp' => '[0][1-9]|[1][0-2]|all', 'param' => 'month')
            ),
            'params' => array(
                'fc' => 'module',
                'module' => 'wpblog'
            )
        ),
        'module-wpblog-rss' => array(
            'controller' =>  'rss',
            'rule' =>        'blog/rss',
            'keywords' => array(),
            'params' => array(
                'fc' => 'module',
                'module' => 'wpblog'
            )
        )
    );
    
    function __construct() {
                
        $this->name = 'wpblog';
        $this->tab = 'front_office_features';
        $this->version = '1.0';
        $this->author = 'Sercan YEMEN';
        $this->need_instance = 0;
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Withinpixels - Blog');
        $this->description = $this->l('Create and manage blog posts');
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function install()
    {
        if (Shop::isFeatureActive()){
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install()
               && $this->registerHook('displayHeader')
               && $this->registerHook('actionShopDataDuplication')
               && $this->registerHook('moduleRoutes')
               && $this->createTables()
               && $this->installData()
               && $this->installTab()
               && $this->createConfig();
    }

    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function uninstall()
    {

        return parent::uninstall()
               && $this->unregisterHook('displayHeader')
               && $this->unregisterHook('actionShopDataDuplication')
               && $this->unregisterHook('moduleRoutes')
               && $this->deleteTables()
               && $this->uninstallTab()
               && $this->removeConfig();
    }
    
    
    /* ------------------------------------------------------------- */
    /*  CREATE THE TABLES
    /* ------------------------------------------------------------- */
    protected function createTables()
    {
        $response = (bool) Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_posts` (
                `id_wpblog_posts` int(10) unsigned NOT NULL AUTO_INCREMENT,
                `id_author` int(10) unsigned NOT NULL,
                `type` varchar(255) NOT NULL,
                `active` tinyint(1) unsigned NOT NULL,
                `sticky` tinyint(1) unsigned NOT NULL,
                `comments` tinyint(1) unsigned NOT NULL,
                `grid_size` varchar(255) NOT NULL,
                `view_count` int(10) unsigned NOT NULL,
                `group_access` varchar(255) NOT NULL,
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                PRIMARY KEY (`id_wpblog_posts`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');

        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_posts_lang` (
                `id_wpblog_posts` int(10) unsigned NOT NULL,
                `id_lang` int(10) unsigned NOT NULL,
                `name` varchar(255) NOT NULL,
                `teaser` text NOT NULL,
                `post` text NOT NULL,
                `tags` text NOT NULL,
                `meta_title` varchar(255) NOT NULL,
                `meta_description` varchar(255) NOT NULL,
                `link_rewrite` varchar(255) NOT NULL,
                `video_embed` text NOT NULL,
                PRIMARY KEY (`id_wpblog_posts`, `id_lang`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_posts_shop` (
                `id_wpblog_posts` int(10) unsigned NOT NULL,
                `id_shop` int(10) unsigned NOT NULL,
                PRIMARY KEY (`id_wpblog_posts`, `id_shop`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_post_cats` (
                `id_wpblog_post_cats` int(10) unsigned NOT NULL AUTO_INCREMENT,
                `id_wpblog_posts` int(10) unsigned NOT NULL,
                `id_wpblog_cats` int(10) unsigned NOT NULL,
                PRIMARY KEY (`id_wpblog_post_cats`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_post_relation` (
                `id_wpblog_post_relation` int(10) unsigned NOT NULL AUTO_INCREMENT,
                `id_wpblog_posts` int(10) unsigned NOT NULL,
                `relation_type` tinyint(3) unsigned NOT NULL,
                `id_related_object` int(10) unsigned NOT NULL,
                PRIMARY KEY (`id_wpblog_post_relation`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_post_images` (
                `id_wpblog_post_images` int(10) unsigned NOT NULL AUTO_INCREMENT,
                `id_wpblog_posts` int(10) unsigned NOT NULL,
                `position` int(10) unsigned NOT NULL,
                `filename` varchar(255) NOT NULL,
                PRIMARY KEY (`id_wpblog_post_images`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_post_comments` (
                `id_wpblog_post_comments` int(10) unsigned NOT NULL AUTO_INCREMENT,
                `id_reply_to` int(10) unsigned NOT NULL,
                `id_wpblog_posts` int(10) unsigned NOT NULL,
                `id_customer` int(10) unsigned NOT NULL,
                `name` varchar(255) NOT NULL,
                `email` varchar(255) NOT NULL,
                `comment` text NOT NULL,
                `active` tinyint(1) unsigned NOT NULL,
                `ip` varchar(255) NOT NULL,
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                PRIMARY KEY (`id_wpblog_post_comments`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_cats` (
                `id_wpblog_cats` int(10) unsigned NOT NULL AUTO_INCREMENT,
                `id_parent_category` int(10) unsigned NOT NULL,
                `depth` int(10) unsigned NOT NULL,
                `deletable` tinyint(1) unsigned NOT NULL DEFAULT \'1\',
                `active` tinyint(1) unsigned NOT NULL,
                `group_access` varchar(255) NOT NULL,
                `date_add` datetime NOT NULL,
                `date_upd` datetime NOT NULL,
                PRIMARY KEY (`id_wpblog_cats`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');

        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_cats_lang` (
                `id_wpblog_cats` int(10) unsigned NOT NULL,
                `id_lang` int(10) unsigned NOT NULL,
                `name` varchar(255) NOT NULL,
                `description` varchar(255) NOT NULL,
                `meta_description` varchar(255) NOT NULL,
                `link_rewrite` varchar(255) NOT NULL,
                PRIMARY KEY (`id_wpblog_cats`, `id_lang`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        $response &= Db::getInstance()->execute('
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'wpblog_cats_shop` (
                `id_wpblog_cats` int(10) unsigned NOT NULL,
                `id_shop` int(10) unsigned NOT NULL,
                PRIMARY KEY (`id_wpblog_cats`, `id_shop`)
            ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=UTF8;
        ');
        
        return $response;
    }

    
    /* ------------------------------------------------------------- */
    /*  DELETE THE TABLES
    /* ------------------------------------------------------------- */
    protected function deleteTables()
    {
        return Db::getInstance()->execute('
            DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'wpblog_posts`,
                                 `' . _DB_PREFIX_ . 'wpblog_posts_lang`,
                                 `' . _DB_PREFIX_ . 'wpblog_posts_shop`,
                                 `' . _DB_PREFIX_ . 'wpblog_post_images`,
                                 `' . _DB_PREFIX_ . 'wpblog_post_cats`,
                                 `' . _DB_PREFIX_ . 'wpblog_post_relation`,
                                 `' . _DB_PREFIX_ . 'wpblog_post_comments`,
                                 `' . _DB_PREFIX_ . 'wpblog_cats`,
                                 `' . _DB_PREFIX_ . 'wpblog_cats_lang`,
                                 `' . _DB_PREFIX_ . 'wpblog_cats_shop`
        ');
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE DATA
    /* ------------------------------------------------------------- */
    protected function installData()
    {
        $languages = Language::getLanguages();
        $id_default_lang = $this->context->language->id;
        $groups = Group::getGroups($id_default_lang);

        /* ADD CATEGORIES */

        $wpBlogCategory = new WPBlogCategoryModel;
        
        // Uncategorized
        $wpBlogCategory->id_parent_category = 0;
        $wpBlogCategory->depth = 0;
        $wpBlogCategory->deletable = 0;
        $wpBlogCategory->active = 1;
        
        $access = array();
        foreach ($groups as $group){
            $access[$group['id_group']] = true;
        }
        $access = serialize($access);
        $wpBlogCategory->group_access = $access;
        
        foreach ($languages as $language){
            $wpBlogCategory->name[$language['id_lang']] = 'Uncategorized';
            $wpBlogCategory->link_rewrite[$language['id_lang']] = 'uncategorized';
        }
        $response = (bool)$wpBlogCategory->add();
        
        if ($response){
            $wpBlogCategory->addBlogCategoryToShops($wpBlogCategory->id);
        }

        // Featured
        $wpBlogCategory->id_parent_category = 0;
        $wpBlogCategory->depth = 0;
        $wpBlogCategory->deletable = 0;
        $wpBlogCategory->active = 1;

        $access = array();
        foreach ($groups as $group){
            $access[$group['id_group']] = true;
        }

        $access = serialize($access);
        $wpBlogCategory->group_access = $access;

        foreach ($languages as $language){
            $wpBlogCategory->name[$language['id_lang']] = 'Featured';
            $wpBlogCategory->link_rewrite[$language['id_lang']] = 'featured';
        }
        $response = (bool)$wpBlogCategory->add();

        if ($response){
            $wpBlogCategory->addBlogCategoryToShops($wpBlogCategory->id);
        }

        return $response;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  INSTALL THE TAB
    /* ------------------------------------------------------------- */
    public function installTab()
    {
		$parentTab = new Tab();
		$parentTab->active = 1;
		$parentTab->name = array();
        $parentTab->class_name = "AdminWPBlog";
		foreach (Language::getLanguages() as $lang){
			$parentTab->name[$lang['id_lang']] = "Withinpixels Blog";
        }
		$parentTab->id_parent = 0;
		$parentTab->module = $this->name;
		$response = $parentTab->add();

        
        $tab = new Tab();
        $tab->active = 1;
		$tab->class_name = "AdminWPBlogCategories";
		$tab->name = array();
		foreach (Language::getLanguages() as $lang){
			$tab->name[$lang['id_lang']] = "Categories";
        }
		$tab->id_parent = $parentTab->id;
		$tab->module = $this->name;
		$response &= $tab->add();
        
        
        $tab = new Tab();
        $tab->active = 1;
		$tab->class_name = "AdminWPBlogPosts";
		$tab->name = array();
		foreach (Language::getLanguages() as $lang){
			$tab->name[$lang['id_lang']] = "Posts";
        }
		$tab->id_parent = $parentTab->id;
		$tab->module = $this->name;
		$response &= $tab->add();
        
        
        $tab = new Tab();
        $tab->active = 1;
		$tab->class_name = "AdminWPBlogComments";
		$tab->name = array();
		foreach (Language::getLanguages() as $lang){
			$tab->name[$lang['id_lang']] = "Comments";
        }
		$tab->id_parent = $parentTab->id;
		$tab->module = $this->name;
		$response &= $tab->add();


        $tab = new Tab();
        $tab->active = 1;
		$tab->class_name = "AdminWPBlogOptions";
		$tab->name = array();
		foreach (Language::getLanguages() as $lang){
			$tab->name[$lang['id_lang']] = "Options";
        }
		$tab->id_parent = $parentTab->id;
		$tab->module = $this->name;
		$response &= $tab->add();
        
        return $response;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE TAB
    /* ------------------------------------------------------------- */  
    public function uninstallTab()
    {
		$id_tabs = array(
            (int)Tab::getIdFromClassName('AdminWPBlog'),
            (int)Tab::getIdFromClassName('AdminWPBlogCategories'),
            (int)Tab::getIdFromClassName('AdminWPBlogPosts'),
            (int)Tab::getIdFromClassName('AdminWPBlogComments')
        );
        
		foreach ($id_tabs as $id_tab){
			$tab = new Tab($id_tab);
			$tab->delete();
		}
        
        return true;
	}
    
    
    /* ------------------------------------------------------------- */
    /*  CREATE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function createConfig()
    {
        // Global options
        $response = Configuration::updateValue('WPBLOG_SHOW_AUTHOR', 1);
        $response &= Configuration::updateValue('WPBLOG_SHOW_VIEWCOUNT', 1);

        // Main blog page options
        $response &= Configuration::updateValue('WPBLOG_BLOG_SIDEBAR_POS', 'right');

        $response &= Configuration::updateValue('WPBLOG_BLOG_FT_POST_LIMIT', 6);
        $response &= Configuration::updateValue('WPBLOG_BLOG_FT_VIEW', 'masonry');
        $response &= Configuration::updateValue('WPBLOG_BLOG_FT_COLCOUNT', 2);

        $response &= Configuration::updateValue('WPBLOG_BLOG_LT_POST_LIMIT', 5);

        // Category options
        $response &= Configuration::updateValue('WPBLOG_CAT_SIDEBAR_POS', 'right');
        $response &= Configuration::updateValue('WPBLOG_CAT_POST_LIMIT', 10);
        $response &= Configuration::updateValue('WPBLOG_CAT_VIEW', 'masonry');
        $response &= Configuration::updateValue('WPBLOG_CAT_COLCOUNT', 2);

        // Post options
        $response &= Configuration::updateValue('WPBLOG_POST_SIDEBAR_POS', 'right');
        $response &= Configuration::updateValue('WPBLOG_POST_ADDTHIS_PUBID', '');

        // Comment options
        $response &= Configuration::updateValue('WPBLOG_COMMENTS', 1);
        $response &= Configuration::updateValue('WPBLOG_NEW_COMMENTS', 1);
        $response &= Configuration::updateValue('WPBLOG_GUEST_COMMENTS', 0);
        $response &= Configuration::updateValue('WPBLOG_COMMENTS_DELAY', 60);
        $response &= Configuration::updateValue('WPBLOG_COMMENTS_AUTOAPPROVAL', 0);
        $response &= Configuration::updateValue('WPBLOG_COMMENTS_THREADED', 1);
        $response &= Configuration::updateValue('WPBLOG_COMMENTS_THREAD_DEPTH', 5);
        
        // Archive options
        $response &= Configuration::updateValue('WPBLOG_ARCHIVE_SIDEBAR_POS', 'right');
        $response &= Configuration::updateValue('WPBLOG_ARCHIVE_POST_LIMIT', 10);
        $response &= Configuration::updateValue('WPBLOG_ARCHIVE_VIEW', 'timeline');
        $response &= Configuration::updateValue('WPBLOG_ARCHIVE_COLCOUNT', 3);

        return $response;
    }
    
    
    /* ------------------------------------------------------------- */
    /*  REMOVE CUSTOM CONFIGURATION VALUES
    /* ------------------------------------------------------------- */
    public function removeConfig()
    {
        // Global options
        $response = Configuration::deleteByName('WPBLOG_SHOW_AUTHOR');
        $response &= Configuration::deleteByName('WPBLOG_SHOW_VIEWCOUNT');

        // Main blog page options
        $response &= Configuration::deleteByName('WPBLOG_BLOG_SIDEBAR_POS');

        $response &= Configuration::deleteByName('WPBLOG_BLOG_FT_POST_LIMIT');
        $response &= Configuration::deleteByName('WPBLOG_BLOG_FT_VIEW');
        $response &= Configuration::deleteByName('WPBLOG_BLOG_FT_COLCOUNT');

        $response &= Configuration::deleteByName('WPBLOG_BLOG_LT_POST_LIMIT');

        // Category options
        $response &= Configuration::deleteByName('WPBLOG_CAT_SIDEBAR_POS');
        $response &= Configuration::deleteByName('WPBLOG_CAT_POST_LIMIT');
        $response &= Configuration::deleteByName('WPBLOG_CAT_VIEW');
        $response &= Configuration::deleteByName('WPBLOG_CAT_COLCOUNT');

        // Post options        
        $response &= Configuration::deleteByName('WPBLOG_POST_SIDEBAR_POS');
        $response &= Configuration::deleteByName('WPBLOG_POST_ADDTHIS_PUBID');

        // Comment options
        $response &= Configuration::deleteByName('WPBLOG_COMMENTS');
        $response &= Configuration::deleteByName('WPBLOG_NEW_COMMENTS');
        $response &= Configuration::deleteByName('WPBLOG_GUEST_COMMENTS');
        $response &= Configuration::deleteByName('WPBLOG_COMMENTS_DELAY');
        $response &= Configuration::deleteByName('WPBLOG_COMMENTS_AUTOAPPROVAL');
        $response &= Configuration::deleteByName('WPBLOG_COMMENTS_THREADED');
        $response &= Configuration::deleteByName('WPBLOG_COMMENTS_THREAD_DEPTH');
        
        // Archive options        
        $response &= Configuration::deleteByName('WPBLOG_ARCHIVE_SIDEBAR_POS');
        $response &= Configuration::deleteByName('WPBLOG_ARCHIVE_POST_LIMIT');
        $response &= Configuration::deleteByName('WPBLOG_ARCHIVE_VIEW');
        $response &= Configuration::deleteByName('WPBLOG_ARCHIVE_COLCOUNT');

        return $response;
    }

    
    /* ------------------------------------------------------------- */
    /*  MODULE INITIALIZE & FORM SUBMIT CHECKs
    /* ------------------------------------------------------------- */
    public function getContent()
    {
        $this->context->controller->addCSS($this->_path.'views/css/admin/wpBlog.css');
        
        $errors = array();
        
        if (Tools::isSubmit('submit'.$this->name)){
            
            // ---------------
            // Global options
            // ---------------
            if (Tools::isSubmit('wpblog_show_author')){
                Configuration::updateValue('WPBLOG_SHOW_AUTHOR', Tools::getValue('wpblog_show_author'));
            }

            if (Tools::isSubmit('wpblog_show_viewcount')){
                Configuration::updateValue('WPBLOG_SHOW_VIEWCOUNT', Tools::getValue('wpblog_show_viewcount'));
            }
            
            // -----------------
            // Main blog page options
            // -----------------
            if (Tools::isSubmit('wpblog_blog_sidebar_pos')){
                Configuration::updateValue('WPBLOG_BLOG_SIDEBAR_POS', Tools::getValue('wpblog_blog_sidebar_pos'));
            }
            
            if (Tools::isSubmit('wpblog_blog_ft_view')){
                Configuration::updateValue('WPBLOG_BLOG_FT_VIEW', Tools::getValue('wpblog_blog_ft_view'));
            }

            if (Tools::isSubmit('wpblog_blog_ft_colcount')){
                Configuration::updateValue('WPBLOG_BLOG_FT_COLCOUNT', Tools::getValue('wpblog_blog_ft_colcount'));
            }
            
            // Validate numeric values
            if (Tools::isSubmit('wpblog_blog_ft_post_limit')){
                if (Validate::isInt(Tools::getValue('wpblog_blog_ft_post_limit'))){
                    Configuration::updateValue('WPBLOG_BLOG_FT_POST_LIMIT', Tools::getValue('wpblog_blog_ft_post_limit'));
                } else {
                    $errors[] = $this->l('Post count must be a numeric value!');
                }
            }

            // Validate numeric values
            if (Tools::isSubmit('wpblog_blog_lt_post_limit')){
                if (Validate::isInt(Tools::getValue('wpblog_blog_lt_post_limit'))){
                    Configuration::updateValue('WPBLOG_BLOG_LT_POST_LIMIT', Tools::getValue('wpblog_blog_lt_post_limit'));
                } else {
                    $errors[] = $this->l('Post count must be a numeric value!');
                }
            }

            // -----------------
            // Category options
            // -----------------
            if (Tools::isSubmit('wpblog_cat_sidebar_pos')){
                Configuration::updateValue('WPBLOG_CAT_SIDEBAR_POS', Tools::getValue('wpblog_cat_sidebar_pos'));
            }

            if (Tools::isSubmit('wpblog_cat_view')){
                Configuration::updateValue('WPBLOG_CAT_VIEW', Tools::getValue('wpblog_cat_view'));
            }

            if (Tools::isSubmit('wpblog_cat_colcount')){
                Configuration::updateValue('WPBLOG_CAT_COLCOUNT', Tools::getValue('wpblog_cat_colcount'));
            }

            // Validate numeric values
            if (Tools::isSubmit('wpblog_cat_post_limit')){
                if (Validate::isInt(Tools::getValue('wpblog_cat_post_limit'))){
                    Configuration::updateValue('WPBLOG_CAT_POST_LIMIT', Tools::getValue('wpblog_cat_post_limit'));
                } else {
                    $errors[] = $this->l('Posts per category must be a numeric value!');
                }
            }
            
            // -------------
            // Post options
            // -------------
            if (Tools::isSubmit('wpblog_post_sidebar_pos')){
                Configuration::updateValue('WPBLOG_POST_SIDEBAR_POS', Tools::getValue('wpblog_post_sidebar_pos'));
            }

            if (Tools::isSubmit('wpblog_post_addthis_pubid')){
                Configuration::updateValue('WPBLOG_POST_ADDTHIS_PUBID', Tools::getValue('wpblog_post_addthis_pubid'));
            }
            
            // ----------------
            // Comment options
            // ----------------
            if (Tools::isSubmit('wpblog_comments')){
                Configuration::updateValue('WPBLOG_COMMENTS', Tools::getValue('wpblog_comments'));
            }

            if (Tools::isSubmit('wpblog_new_comments')){
                Configuration::updateValue('WPBLOG_NEW_COMMENTS', Tools::getValue('wpblog_new_comments'));
            }
            
            if (Tools::isSubmit('wpblog_guest_comments')){
                Configuration::updateValue('WPBLOG_GUEST_COMMENTS', Tools::getValue('wpblog_guest_comments'));
            }
            
            if (Tools::isSubmit('wpblog_comments_autoapproval')){
                Configuration::updateValue('WPBLOG_COMMENTS_AUTOAPPROVAL', Tools::getValue('wpblog_comments_autoapproval'));
            }
            
            if (Tools::isSubmit('wpblog_comments_threaded')){
                Configuration::updateValue('WPBLOG_COMMENTS_THREADED', Tools::getValue('wpblog_comments_threaded'));
            }
            
            // Validate numeric values
            if (Tools::isSubmit('wpblog_comments_delay')){
                if (Validate::isInt(Tools::getValue('wpblog_comments_delay'))){
                    Configuration::updateValue('WPBLOG_COMMENTS_DELAY', Tools::getValue('wpblog_comments_delay'));
                } else {
                    $errors[] = $this->l('Comment delay must be numeric!');
                }
            }
            
            if (Tools::isSubmit('wpblog_comments_thread_depth')){
                if (Validate::isInt(Tools::getValue('wpblog_comments_thread_depth'))){
                    Configuration::updateValue('WPBLOG_COMMENTS_THREAD_DEPTH', Tools::getValue('wpblog_comments_thread_depth'));
                } else {
                    $errors[] = $this->l('Comment thread depth must be numeric!');
                }
            }
            
            // ----------------
            // Archive options
            // ----------------
            if (Tools::isSubmit('wpblog_archive_sidebar_pos')){
                Configuration::updateValue('WPBLOG_ARCHIVE_SIDEBAR_POS', Tools::getValue('wpblog_archive_sidebar_pos'));
            }
            
            if (Tools::isSubmit('wpblog_archive_view')){
                Configuration::updateValue('WPBLOG_ARCHIVE_VIEW', Tools::getValue('wpblog_archive_view'));
            }

            if (Tools::isSubmit('wpblog_archive_colcount')){
                Configuration::updateValue('WPBLOG_ARCHIVE_COLCOUNT', Tools::getValue('wpblog_archive_colcount'));
            }
            
            // Validate numeric values
            if (Tools::isSubmit('wpblog_archive_post_limit')){
                if (Validate::isInt(Tools::getValue('wpblog_archive_post_limit'))){
                    Configuration::updateValue('WPBLOG_ARCHIVE_POST_LIMIT', Tools::getValue('wpblog_archive_post_limit'));
                } else {
                    $errors[] = $this->l('Posts per category must be a numeric value!');
                }
            }
            
            
            // Prepare the output
            if (count($errors)){
                $this->_output .= $this->displayError(implode('<br />', $errors));
            } else {
                $this->_output .= $this->displayConfirmation($this->l('Configuration updated'));
            }
            
        }
        
        return $this->_output.$this->displayForm();
    }

    
    /* ------------------------------------------------------------- */
    /*  DISPLAY CONFIGURATION FORM
    /* ------------------------------------------------------------- */
    public function displayForm()
    {
        // Get default Language
        $default_lang = (int) Configuration::get('PS_LANG_DEFAULT');
                
        // Sidebar positions
		$sidebar_positons = array(
			array(
				'value' => 'left',
				'name' => $this->l('Left')
			),
			array(
				'value' => 'right',
				'name' => $this->l('Right')
			)
		);
        
        // View types
		$view_types = array(
			array(
				'value' => 'timeline',
				'name' => $this->l('Timeline')
			),
			array(
				'value' => 'grid',
				'name' => $this->l('Grid')
			),
			array(
				'value' => 'masonry',
				'name' => $this->l('Masonry')
			)
		);

        // Column Counts
        $col_counts = array(
            array(
                'value' => '1',
                'name' => '1 column'
            ),
            array(
                'value' => '2',
                'name' => '2 columns'
            ),
            array(
                'value' => '3',
                'name' => '3 columns'
            ),
            array(
                'value' => '4',
                'name' => '4 columns'
            )
        );

        $fields_form = array(
            'wpblog-general' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('General'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show author name'),
                            'name' => 'wpblog_show_author',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'author_on',
                                    'value' => 1,
                                    'label' => $this->l('Show')
                                ),
                                array(
                                    'id' => 'active_off',
                                    'value' => 0,
                                    'label' => $this->l('Hide')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show post view count'),
                            'name' => 'wpblog_show_viewcount',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'viewcount_on',
                                    'value' => 1,
                                    'label' => $this->l('Show')
                                ),
                                array(
                                    'id' => 'viewcount_off',
                                    'value' => 0,
                                    'label' => $this->l('Hide')
                                )
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogOptions'
                    )
                )
            ),
            'wpblog-blog' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Main blog page'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'label' => $this->l('Sidebar position'),
                            'name' => 'wpblog_blog_sidebar_pos',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $sidebar_positons,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Number of featured posts'),
                            'name' => 'wpblog_blog_ft_post_limit',
                            'required' => true,
                            'lang' => false
                        ),
                        array(
                            'type' => 'select',
                            'label' => $this->l('View type of featured products'),
                            'name' => 'wpblog_blog_ft_view',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $view_types,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'label' => $this->l('Column count of featured products'),
                            'desc' => $this->l('Only for "Grid" and "Masonry" view types'),
                            'name' => 'wpblog_blog_ft_colcount',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $col_counts,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Number of latest posts'),
                            'name' => 'wpblog_blog_lt_post_limit',
                            'required' => true,
                            'lang' => false
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogOptions'
                    )
                )
            ),
            'wpblog-category' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Categories'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'label' => $this->l('Sidebar position'),
                            'name' => 'wpblog_cat_sidebar_pos',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $sidebar_positons,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Posts per page'),
                            'name' => 'wpblog_cat_post_limit',
                            'required' => true,
                            'lang' => false,
                            'suffix' => $this->l('posts per page')
                        ),
                        array(
                            'type' => 'select',
                            'label' => $this->l('View type'),
                            'name' => 'wpblog_cat_view',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $view_types,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'label' => $this->l('Column count'),
                            'desc' => $this->l('Only for "Grid" and "Masonry" view types'),
                            'name' => 'wpblog_cat_colcount',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $col_counts,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogOptions'
                    )
                )
            ),
            'wpblog-post' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Posts'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'label' => $this->l('Sidebar position'),
                            'name' => 'wpblog_post_sidebar_pos',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $sidebar_positons,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('AddThis Public ID:'),
                            'desc' => $this->l('Post sharing buttons using a widget from addthis.com. You can signup to addthis.com and paste your Public ID over here to keep track the sharing analytics. Public ID is not required, sharing buttons will still work properly even if you dont have it.'),
                            'name' => 'wpblog_post_addthis_pubid',
                            'required' => false,
                            'lang' => false,
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogOptions'
                    )
                )
            ),
            'wpblog-comment' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Comments'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Comments'),
                            'desc' => $this->l('Enable or disable comment functionality completely.'),
                            'name' => 'wpblog_comments',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'comments_on',
                                    'value' => 1,
                                    'label' => $this->l('Enable')
                                ),
                                array(
                                    'id' => 'comments_off',
                                    'value' => 0,
                                    'label' => $this->l('Disable')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Allow new comments'),
                            'desc' => $this->l('This will remove the comment form, current comments will stay visible.'),
                            'name' => 'wpblog_new_comments',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'new_comments_on',
                                    'value' => 1,
                                    'label' => $this->l('Allow')
                                ),
                                array(
                                    'id' => 'new_comments_off',
                                    'value' => 0,
                                    'label' => $this->l('Disallow')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Allow guest comments'),
                            'desc' => $this->l('Disable to allow comments from only registered users.'),
                            'name' => 'wpblog_guest_comments',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'guest_comments_on',
                                    'value' => 1,
                                    'label' => $this->l('Allow')
                                ),
                                array(
                                    'id' => 'guest_comments_off',
                                    'value' => 0,
                                    'label' => $this->l('Disallow')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Auto approve comments'),
                            'desc' => $this->l('Automatically approve new comments.'),
                            'name' => 'wpblog_comments_autoapproval',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'autoapproval_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'autoapproval_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Delay between two comments'),
                            'desc' => $this->l('Default: 60 - This option is extremely important to fight with spam, do not set it to 0(zero)!'),
                            'name' => 'wpblog_comments_delay',
                            'required' => true,
                            'lang' => false,
                            'suffix' => $this->l('seconds')
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Enable threaded comments'),
                            'name' => 'wpblog_comments_threaded',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'threaded_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'threaded_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Max thread depth'),
                            'desc' => $this->l('Default: 5'),
                            'name' => 'wpblog_comments_thread_depth',
                            'required' => true,
                            'lang' => false
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogOptions'
                    )
                )
            ),
            'wpblog-archive' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Archives'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'label' => $this->l('Sidebar position'),
                            'name' => 'wpblog_archive_sidebar_pos',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $sidebar_positons,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Posts per page'),
                            'name' => 'wpblog_archive_post_limit',
                            'required' => true,
                            'lang' => false,
                            'suffix' => $this->l('posts per page')
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'wpblog_archive_view',
                            'label' => $this->l('View type'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $view_types,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'label' => $this->l('Column count'),
                            'desc' => $this->l('Only for "Grid" and "Masonry" view types'),
                            'name' => 'wpblog_archive_colcount',
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $col_counts,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveBlogOptions'
                    )
                )
            )
        );
        
        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;

        $helper->default_form_language = $default_lang;
        $helper->allow_employee_form_lang = $default_lang;

        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit'.$this->name;
        $helper->toolbar_btn = array(
            'save' => array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex.'&configure='.$this->name.'&save'.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
            ),
            'back' => array(
                'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
                'desc' => $this->l('Back to list')
            )
        );

        // Load current values
        // Global options 
        $helper->fields_value['wpblog_show_author'] = Configuration::get('WPBLOG_SHOW_AUTHOR');
        $helper->fields_value['wpblog_show_viewcount'] = Configuration::get('WPBLOG_SHOW_VIEWCOUNT');

        // Main blog page options
        $helper->fields_value['wpblog_blog_sidebar_pos'] = Configuration::get('WPBLOG_BLOG_SIDEBAR_POS');

        $helper->fields_value['wpblog_blog_ft_post_limit'] = Configuration::get('WPBLOG_BLOG_FT_POST_LIMIT');
        $helper->fields_value['wpblog_blog_ft_view'] = Configuration::get('WPBLOG_BLOG_FT_VIEW');
        $helper->fields_value['wpblog_blog_ft_colcount'] = Configuration::get('WPBLOG_BLOG_FT_COLCOUNT');

        $helper->fields_value['wpblog_blog_lt_post_limit'] = Configuration::get('WPBLOG_BLOG_LT_POST_LIMIT');

        // Category options
        $helper->fields_value['wpblog_cat_sidebar_pos'] = Configuration::get('WPBLOG_CAT_SIDEBAR_POS');
        $helper->fields_value['wpblog_cat_post_limit'] = Configuration::get('WPBLOG_CAT_POST_LIMIT');
        $helper->fields_value['wpblog_cat_view'] = Configuration::get('WPBLOG_CAT_VIEW');
        $helper->fields_value['wpblog_cat_colcount'] = Configuration::get('WPBLOG_CAT_COLCOUNT');

        // Post options
        $helper->fields_value['wpblog_post_sidebar_pos'] = Configuration::get('WPBLOG_POST_SIDEBAR_POS');
        $helper->fields_value['wpblog_post_addthis_pubid'] = Configuration::get('WPBLOG_POST_ADDTHIS_PUBID');

        // Comment options
        $helper->fields_value['wpblog_comments'] = Configuration::get('WPBLOG_COMMENTS');
        $helper->fields_value['wpblog_new_comments'] = Configuration::get('WPBLOG_NEW_COMMENTS');
        $helper->fields_value['wpblog_guest_comments'] = Configuration::get('WPBLOG_GUEST_COMMENTS');
        $helper->fields_value['wpblog_comments_delay'] = Configuration::get('WPBLOG_COMMENTS_DELAY');
        $helper->fields_value['wpblog_comments_autoapproval'] = Configuration::get('WPBLOG_COMMENTS_AUTOAPPROVAL');
        $helper->fields_value['wpblog_comments_threaded'] = Configuration::get('WPBLOG_COMMENTS_THREADED');
        $helper->fields_value['wpblog_comments_thread_depth'] = Configuration::get('WPBLOG_COMMENTS_THREAD_DEPTH');
        
        // Archive options
        $helper->fields_value['wpblog_archive_sidebar_pos'] = Configuration::get('WPBLOG_ARCHIVE_SIDEBAR_POS');
        $helper->fields_value['wpblog_archive_post_limit'] = Configuration::get('WPBLOG_ARCHIVE_POST_LIMIT');
        $helper->fields_value['wpblog_archive_view'] = Configuration::get('WPBLOG_ARCHIVE_VIEW');
        $helper->fields_value['wpblog_archive_colcount'] = Configuration::get('WPBLOG_ARCHIVE_COLCOUNT');

        return $helper->generateForm($fields_form);
    
    }
    
    
    /* ------------------------------------------------------------- */
    /*  HOOK THE MODULE INTO SHOP DATA DUPLICATION ACTION
    /* ------------------------------------------------------------- */
    public function hookActionShopDataDuplication($params)
    {
        Db::getInstance()->execute('
                INSERT IGNORE INTO '._DB_PREFIX_.'wpblog_cats_shop (id_wpblog_cats, id_shop)
                SELECT id_wpblog_cats, '.(int)$params['new_id_shop'].'
                FROM '._DB_PREFIX_.'wpblog_cats_shop
                WHERE id_shop = '.(int)$params['old_id_shop']
        );
    }
    
       
    /* ------------------------------------------------------------- */
    /*  HOOK THE MODULE INTO MODULE ROUTES
    /* ------------------------------------------------------------- */
    public function hookModuleRoutes($params)
    {
        return self::$moduleRoute;
    }
    
        
    /* ------------------------------------------------------------- */
    /*
    /* FRONT OFFICE
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  PREPARE FOR HOOK
    /* ------------------------------------------------------------- */
    private function _prepHook($params)
    {

        return true;
    }

    
    /* ------------------------------------------------------------- */
    /*  HOOK (displayHeader)
    /* ------------------------------------------------------------- */
    public function hookDisplayHeader($params)
    {
        $this->_prepHook($params);

        return $this->display(__FILE__, 'views/templates/front/custom/header.tpl');
    }

}
