<div id="wpproductautocomplete">
    <div id="ajax_choose_product">
        <input type="text" value="" id="product_autocomplete_input" />
        <p class="help-block">{l s='Begin typing the first letters of the product name, then select the product from the drop-down list. Related products will automatically be saved.'}</p>
    </div>

    <div id="product_list" style="font-weight:bold;">
        <ul>
            {if (isset($blog_related_products) && $blog_related_products)}
                {foreach $blog_related_products as $blog_related_product}
                    <li data-pid="{$blog_related_product.id}">{$blog_related_product.name} (ref: {$blog_related_product.ref})<span class="delProduct" data-pid="{$blog_related_product.id}" style="cursor: pointer;"><img src="../img/admin/delete.gif" /></span></li>
                {/foreach}
            {/if}
        </ul>
    </div>
</div>

<script type="text/javascript">

    {literal}
    $(document).ready(function(){
        productAutocomplete.init();
    });

    var productAutocomplete = new function (){
        var self = this;

        this.init = function(){

            $('#product_autocomplete_input')
                    .autocomplete('ajax_products_list.php', {
                        minChars: 1,
                        autoFill: true,
                        max:20,
                        matchContains: true,
                        mustMatch:true,
                        scroll:false,
                        cacheLength:0,
                        formatItem: function(item) {
                            return item[1]+' - '+item[0];
                        }
                    }).result(self.addProduct);

            $('#product_autocomplete_input').setOptions({
                extraParams: {
                    excludeIds : self.getProductIds()
                }
            });

            $('#product_list').on('click', '.delProduct', function(){
                self.delProduct($(this).attr('data-pid'));
            });
        }

        this.addProduct = function(event, data, formatted)
        {
            if (data == null)
                return false;
            var productId = data[1];
            var productName = data[0];

            doAdminAjax({
                    "action":"addPostRelatedProduct",
                    "id_wpblog_posts":{/literal}{$id_wpblog_posts}{literal},
                    "id_related_product":productId,
                    "token" : "{/literal}{$token}{literal}",
                    "tab" : "AdminWPBlogPosts",
                    "ajax" : 1
                },
                function(response){
                    // If success
                    response = $.parseJSON(response);
                    if (response.confirmations.length != 0)
                    {
                        showSuccessMessage(response.confirmations);

                        $('#product_list ul').append('<li data-pid="' + productId + '">' + productName + '<span class="delProduct" data-pid="' + productId + '" style="cursor: pointer;"><img src="../img/admin/delete.gif" /></span></li>');

                        $('#product_autocomplete_input').setOptions({
                            extraParams: { excludeIds : self.getProductIds() }
                        });
                    }
                    else
                    {
                        showErrorMessage(response.error);
                    }
                }
            );

            $('#product_autocomplete_input').val('');
        };

        this.delProduct = function(id)
        {
            doAdminAjax({
                    "action":"deletePostRelatedProduct",
                    "id_wpblog_posts":{/literal}{$id_wpblog_posts}{literal},
                    "id_related_product":id,
                    "token" : "{/literal}{$token}{literal}",
                    "tab" : "AdminWPBlogPosts",
                    "ajax" : 1
                },
                function(response){
                    // If success
                    response = $.parseJSON(response);
                    if (response.confirmations.length != 0)
                    {
                        showSuccessMessage(response.confirmations);

                        $('#product_list ul').find('li[data-pid=' + id +']').remove();

                        $('#product_autocomplete_input').setOptions({
                            extraParams: { excludeIds : self.getProductIds() }
                        });
                    }
                    else
                    {
                        showErrorMessage(response.error);
                    }
                }
            );
        };

        this.getProductIds = function()
        {
            var productIDs = '';

            $('#product_list').find('li').each(function(){
                productIDs += $(this).attr('data-pid') + ',';
            });

            return productIDs.slice(0, -1);
        };
    };
    {/literal}
</script>