<?php

class WPBlogPostRelationModel extends ObjectModel
{
    public $id_wpblog_post_relation;
    public $id_wpblog_posts;
    public $relation_type;
    public $id_related_object;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'wpblog_post_relation',
        'primary' => 'id_wpblog_post_relation',
        'multilang' => false,
        'fields' => array(   
            //Fields
            'id_wpblog_posts'   =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'relation_type'     =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
            'id_related_object' =>  array('type' => self::TYPE_INT, 'validate' => 'isUnsignedInt'),
        )
    );
        
    public function __construct($id_wpblog_post_relation = null, $id_lang = null, $id_shop = null)
    {
        parent::__construct($id_wpblog_post_relation, $id_lang, $id_shop);
    }

    /*-------------------------------------------------------------*/
    /*  GET RELATED OBJECT ID
    /*-------------------------------------------------------------*/
    public static function getRelatedObjectID($id_wpblog_posts, $id_related_object, $relation_type = 1)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow(
            'SELECT id_wpblog_post_relation
            FROM '._DB_PREFIX_.'wpblog_post_relation
            WHERE id_wpblog_posts = '.$id_wpblog_posts.'
            AND id_related_object = '.$id_related_object.'
            AND relation_type = '.$relation_type
        );

        return $response['id_wpblog_post_relation'];
    }

    /*-------------------------------------------------------------*/
    /*  GET BLOG RELATED OBJECTS
    /*-------------------------------------------------------------*/
    /**
     * @param     $id_wpblog_posts
     * @param int $relation_type Product: 1, Category: 2
     *
     * @return array
     */
    public static function getBlogRelatedObjects($id_wpblog_posts, $relation_type = 1)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
            'SELECT id_related_object
            FROM '._DB_PREFIX_.'wpblog_post_relation
            WHERE id_wpblog_posts = '.$id_wpblog_posts.'
            AND relation_type = '.$relation_type
            );

        return $response;
    }

    /*-------------------------------------------------------------*/
    /*  GET POST ID BY RELATED OBJECT ID
    /*-------------------------------------------------------------*/
    public static function getBlogPostID($id_related_object, $relation_type = 1, $limit = 0)
    {
        $query = 'SELECT id_wpblog_posts
                  FROM '._DB_PREFIX_.'wpblog_post_relation
                  WHERE id_related_object = '.$id_related_object.'
                  AND relation_type = '.$relation_type;

        if ($limit > 0){
            $query .= ' LIMIT ' . $limit;
        }

        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        return $response;
    }

    /*-------------------------------------------------------------*/
    /*  CHECK IF RELATION EXISTS
    /*-------------------------------------------------------------*/
    public static function isRelationExist($id_wpblog_posts, $id_related_object, $relation_type = 1)
    {
        $response = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
            'SELECT COUNT(id_related_object)
            FROM '._DB_PREFIX_.'wpblog_post_relation
            WHERE id_wpblog_posts = '.$id_wpblog_posts.'
            AND id_related_object = '.$id_related_object.'
            AND relation_type = '.$relation_type
            );

        if ((int)$response[0]['COUNT(id_related_object)'] > 0){
            return true;
        } else {
            return false;
        }
    }

}
