<?php

require_once(dirname(__FILE__).'/../custom/wpblogFrontController.php');

class wpblogpostModuleFrontController extends wpblogFrontController
{
    private $id_wpblog_posts;

    // Template
    public $wpblog_template = 'post/post-layout.tpl';
    
    public function __construct()
    {
        parent::__construct();
    }
    
    public function initContent()
    {
        $id_default_lang = $this->context->language->id;
        $id_shop = $this->context->shop->id;
        $blogImageDir = $this->context->link->getMediaLink(_MODULE_DIR_ . 'wpblog/views/uploads/');

        if (Tools::isSubmit('id_wpblog_posts') && Validate::isInt(Tools::getValue('id_wpblog_posts'))) {
            $this->id_wpblog_posts = Tools::getValue('id_wpblog_posts');
        } else {
            return false;
        }

        // Get the post
        $wpBlogPost = new WPBlogPostModel($this->id_wpblog_posts, $id_default_lang, $id_shop);

        // If current user's group and post's group access intersecting, then add it to the array
        if (!$wpBlogPost->isAccessGranted()){
            $this->context->smarty->assign('wp_restricted_access', true);
            parent::initContent();
            return false;
        }

        // Increase the view count
        if (Configuration::get('WPBLOG_SHOW_VIEWCOUNT')){
            $wpBlogPost->increaseViewCount();
        }

        $post = array();

        $post['id_wpblog_posts'] = $wpBlogPost->id_wpblog_posts;
        $post['name'] = $wpBlogPost->name;
        $post['post'] = $wpBlogPost->post;
        $post['type'] = $wpBlogPost->type;

        // Grab stuff according to the post type
        if ($wpBlogPost->type == 'gallery' || $wpBlogPost->type == 'slider'){
            $postImages = wpBlogPostImages::getImages($wpBlogPost->id_wpblog_posts);
            if ($postImages){
                $post['allImages'] = $postImages;
            }
        } elseif ($wpBlogPost->type == 'standard') {
            $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
            if ($featuredImage){
                $post['featuredImage'] = $featuredImage['filename'];
            }
        } elseif ($wpBlogPost->type == 'video') {
            $post['video_embed'] = $wpBlogPost->video_embed;

            $featuredImage = wpBlogPostImages::getFeaturedImage($wpBlogPost->id_wpblog_posts);
            if ($featuredImage){
                $post['featuredImage'] = $featuredImage['filename'];
            }
        }
        
        // Get post categories and build their links
        $postCategories = $wpBlogPost->getBlogPostCategories($this->id_wpblog_posts);
        
        foreach ($postCategories as $key => $postCategory){
            $wpBlogCategory = new WPBlogCategoryModel($postCategory['id_wpblog_cats'], $id_default_lang, $id_shop);
            $post['postCategories'][$postCategory['id_wpblog_cats']]['name'] = $wpBlogCategory->name;
            $post['postCategories'][$postCategory['id_wpblog_cats']]['link'] = $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats'=>$postCategory['id_wpblog_cats'], 'rewrite'=>$wpBlogCategory->link_rewrite));
        }
        
        // Get the author name
        $employee = New Employee($wpBlogPost->id_author);
        $post['author'] = $employee->firstname;

        // Format the dates
        $post['published_on'] = Tools::displayDate($wpBlogPost->date_add, null, false, null);
        
        // Create a link to post
        $post['link'] = $this->context->link->getModuleLink('wpblog', 'post', array('id_wpblog_posts'=>$wpBlogPost->id_wpblog_posts, 'rewrite'=>$wpBlogPost->link_rewrite));
        
        // Get the tags
        if ($wpBlogPost->tags != ''){
            $tags = explode(',', $wpBlogPost->tags);
            foreach ($tags as $tag){
                strip_tags($tag);
                $tagSearchLink = $this->context->link->getPageLink('search', true, null, 'search_query='.$tag);

                $post['alltags'][] = array(
                    'tag' =>  $tag,
                    'link' => $tagSearchLink
                );
            }
        }

        // Get the view count
        if (Configuration::get('WPBLOG_SHOW_VIEWCOUNT')){
            $post['view_count'] = $wpBlogPost->view_count;
        }


        // Fill page information
        if ($wpBlogPost->meta_title != ''){
            $this->meta_title = $wpBlogPost->meta_title;
        } else {
            $this->meta_title = $wpBlogPost->name;
        }
        $this->meta_description = $wpBlogPost->meta_description;
        $this->meta_keywords = $wpBlogPost->tags;
        
        // Check comment status from both general options and post specific options and get comments if they are allowed
        $allow_comments = false;
        $allow_comments_post = $wpBlogPost->comments;
        $allow_comments_general = Configuration::get('WPBLOG_COMMENTS');
        
        if ($allow_comments_post && $allow_comments_general) {
            $wpBlogComment = new WPBlogCommentModel();
            $comments = $wpBlogComment->getComments($wpBlogPost->id_wpblog_posts);
            $commentsCount = $wpBlogComment->getCommentsCount($wpBlogPost->id_wpblog_posts);
            $allow_comments = true;
        }
        
        // Get logged in user name and e-mail if the user logged in
        if ($this->context->customer->isLogged()){
            $customerFName = $this->context->customer->firstname;
            $customerEmail = $this->context->customer->email;
        }

        // Check and get related products if they exist
        // We will only get some basic information of the products
        if ($relatedObjects = WPBlogPostRelationModel::getBlogRelatedObjects($wpBlogPost->id_wpblog_posts, 1))
        {
            $relatedProducts = array();

            foreach ($relatedObjects as $relatedObject){
                $product = new Product($relatedObject['id_related_object'], false, $id_default_lang, $id_shop);
                if (!$product->active){
                    continue;
                }

                // Get cover image id
                $id_cover_image = $product->getCover($product->id);

                $relatedProducts[] = array(
                    'id_product' => $product->id,
                    'link' => $product->getLink(),
                    'link_rewrite' => $product->link_rewrite,
                    'name' => $product->name,
                    'id_image' => $id_cover_image['id_image']
                );
            }
        }

        // Assign hooks
        $hooks = array(
            'displayWPBlogSidebar'
        );

        foreach ($hooks as $hook){
            $this->context->smarty->assign('hook_'.$hook, Hook::exec($hook));
        }

        // Send stuff to the template
        $this->context->smarty->assign(
            array(
                'post'           => $post,
                'allow_comments' => $allow_comments,
                'blogImageDir'   => $blogImageDir,
                'WPBLOG_SHOW_AUTHOR' => Configuration::get('WPBLOG_SHOW_AUTHOR'),
                'WPBLOG_POST_SIDEBAR_POS' => Configuration::get('WPBLOG_POST_SIDEBAR_POS'),
                'WPBLOG_POST_ADDTHIS_PUBID' => Configuration::get('WPBLOG_POST_ADDTHIS_PUBID'),
                'WPBLOG_COMMENTS' => Configuration::get('WPBLOG_COMMENTS'),
                'WPBLOG_NEW_COMMENTS' => Configuration::get('WPBLOG_NEW_COMMENTS'),
                'WPBLOG_GUEST_COMMENTS' => Configuration::get('WPBLOG_GUEST_COMMENTS')
            )
        );
        
        if (isset($comments)){
            $this->context->smarty->assign('comments', $comments);
            $this->context->smarty->assign('commentsCount', $commentsCount);
        }

        if (isset($relatedProducts) && !empty($relatedProducts)){
            $this->context->smarty->assign('relatedProducts', $relatedProducts);
        }

        if (isset($customerFName) && isset($customerEmail)){
            $this->context->smarty->assign(
                array(
                    'customerFName' => $customerFName,
                    'customerEmail' => $customerEmail
                )
            );
        }
        
        parent::initContent();
    }
    
    public function postProcess()
    {

        // Process the posted data a.k.a. comments

        $id_wpblog_posts = Tools::getValue('commentPostID');

        // Limit this by doing this otherwise it will run every time the page loads
        if ($id_wpblog_posts && Validate::isInt($id_wpblog_posts))
        {
            $errors = array();
            $user_id = 0;
            
            if ($this->context->customer->isLogged()){
                $user_name = $this->context->customer->firstname;
                $user_email = $this->context->customer->email;
                $user_id = $this->context->customer->id;
            } else {
                if (Tools::isSubmit('commentName') && Tools::isSubmit('commentEmail') && Tools::getValue('commentName') != '' && Tools::getValue('commentEmail') != ''){
                    if (Validate::isCleanHtml(Tools::getValue('commentName'))){
                        $user_name = Tools::getValue('commentName');
                    } else {
                         $errors[] = $this->module->l('Only alpha-numeric charachters are allowed for name field!');
                    }

                    if (Validate::isEmail(Tools::getValue('commentEmail'))){
                        $user_email = Tools::getValue('commentEmail');
                    } else {
                         $errors[] = $this->module->l('Please enter a valid e-mail address!');
                    }
                } else {
                    $errors[] = $this->module->l('Please fill both name and e-mail fields!');
                }
            }

            if (Tools::isSubmit('commentBody') && Tools::getValue('commentBody') != ''){
                if (Validate::isGenericName(Tools::getValue('commentBody'))){
                    $comment_body = Tools::getValue('commentBody');
                } else {
                    $errors[] = $this->module->l('HTML is not allowed in comment body!');
                }
            } else {
                $errors[] = $this->module->l('Please fill the comment field!');
            }

            if (!Validate::isInt(Tools::getValue('commentReplyTo'))) {
                $errors[] = $this->module->l('Are you trying to hack?');
            } else {
                $id_replyTo = Tools::getValue('commentReplyTo');
            }

            // Show the errors if there is any, otherwise add the comment to the DB
            if (count($errors)){
                $this->errors = $errors;
            } else {
                
                // Spam check
                // if user is not a customer, we are going to use the user's ip address to check if he/she added something before
                $ip_address = Tools::getRemoteAddr();
                $previousComment = WPBlogCommentModel::checkUserComments($id_wpblog_posts, $ip_address, $user_id);
                
                // Get wait time from config
                $waitTime = Configuration::get('WPBLOG_COMMENTS_DELAY');
                
                // Check if same person added something to the same post without waiting proper amount of time
                if ($previousComment){
                    $now = new DateTime();
                    $nowTimestamp = $now->getTimestamp();

                    $comment_date = new Datetime($previousComment['date_add']);
                    $commentTimestamp = $comment_date->getTimestamp();

                    $diff = abs($nowTimestamp - $commentTimestamp);
                    if ($diff < $waitTime){
                        $this->errors = $this->module->l('You have to wait before send another comment!');
                        return false;
                    }
                }
                
                $wpBlogComments = new WPBlogCommentModel();
                
                $wpBlogComments->id_customer = $user_id;

                $wpBlogComments->id_reply_to = $id_replyTo;
                $wpBlogComments->id_wpblog_posts = $id_wpblog_posts;

                $wpBlogComments->name = $user_name;
                $wpBlogComments->email = $user_email;
                $wpBlogComments->comment = $comment_body;
                
                $auto_approval = Configuration::get('WPBLOG_COMMENTS_AUTOAPPROVAL');
                
                if ($auto_approval){
                    $wpBlogComments->active = 1;
                } else {
                    $wpBlogComments->active = 0;
                }
                
                $wpBlogComments->ip = $ip_address;
                
                $result = $wpBlogComments->add();
                
                if ($result)
                {
                    if ($auto_approval){
                        $conf_message = $this->module->l('Your comment has been saved.');
                    } else {
                        $conf_message = $this->module->l('Your comment has been saved and it will be published after reviewed.');
                    }
                    $this->context->smarty->assign('confirmation', $conf_message);
                } else {
                    $this->errors = $this->module->l('database error!');
                }
            }
        }
    }
    
}