<?php

class wpblogPagination extends wpblogFrontController
{
    
    /**
     * Pagination type
     *
     * @var  string
     */
    public $pagination_type = 'category';
    
    /**
     * Current page
     *
     * @var  integer
     */
    public $current_page = 0;

    /**
     * Total page count
     *
     * @var  integer
     */
    public $total_pages = 0;

    /**
     * Category id that will be used while creating page links
     *
     * @var  string
     */
    public $id_wpblog_cats = '';
    
    /**
     * Friendly url that will be used while creating page links
     *
     * @var  string
     */
    public $rewrite = '';
    
    /**
     * Year value for archive pages
     *
     * @var  integer
     */
    public $year = 0;
    
    /**
     * Month value for archive pages
     *
     * @var  integer
     */
    public $month = 0;

    /**
     * Keyword for the url that determines the page count
     *
     * @var  string
     */
    public $page_keyword = 'p';

    /**
     * HTML before the current page number
     *
     * @var  string
     */
    public $html_before_current_page = '';

    /**
     * HTML after the current page number
     *
     * @var  string
     */
    public $html_after_current_page = '';

    /**
     * HTML before the current page number
     *
     * @var  string
     */
    public $previous_button_text = '<';

    /**
     * HTML after the current page number
     *
     * @var  string
     */
    public $next_button_text = '>';
    
    private $pagination = '';
    private $page_count = 9;
    private $page_link = '';
    
    public function __construct()
    {
        
    }

    public function createPagination()
    {
        return $this->initialize();
    }

    private function initialize()
    {
        if ($this->total_pages > 1)
        {

            // Previous page link
            if ((int) ($this->current_page - 1) >= 1)
            {   
                if ($this->pagination_type == 'category')
                {
                    $this->pagination .= '<div class="pagination previous"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => (int) ($this->current_page - 1))) . '">' . $this->previous_button_text . '</a></div>';
                }
                elseif ($this->pagination_type == 'archive')
                {
                    if ($this->month != null){
                        $this->pagination .= '<div class="pagination previous"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => (int) ($this->current_page - 1))) . '">' . $this->previous_button_text . '</a></div>';
                    } else {
                        $this->pagination .= '<div class="pagination previous"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => (int) ($this->current_page - 1))) . '">' . $this->previous_button_text . '</a></div>';
                    }
                }
            }
            else
            {
                $this->pagination .= '<div class="pagination previous disabled"><span class="pagination-link">' . $this->previous_button_text . '</span></div>';
            }

            // We don't have enough pages to activate smart pagination
            if ($this->total_pages < $this->page_count)
            {
                // Iterate the page count starting from 1
                for ($p = 1; $p <= $this->total_pages; $p++)
                {
                    if ($p == $this->current_page)
                    {
                        $this->pagination .= '<div class="pagination current"><span class="pagination-link">' . $this->html_before_current_page . $p . $this->html_after_current_page . '</span></div>';
                    }
                    else
                    {
                        if ($this->pagination_type == 'category')
                        {
                            $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                        }
                        elseif ($this->pagination_type == 'archive')
                        {
                            if ($this->month != null){
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                            } else {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                        }
                    }
                }
            }
            // We have enough pages to activate smart pagination
            else
            {
                // Current page is close to start, so we will show first 5 links at all times and break the end of the pagination
                if ($this->current_page <= 4)
                {
                    for ($p = 1; $p <= 5; $p++)
                    {
                        if ($p == $this->current_page)
                        {
                            $this->pagination .= '<div class="pagination current"><span class="pagination-link">' . $this->html_before_current_page . $p . $this->html_after_current_page . '</span></div>';
                        }
                        else
                        {
                            if ($this->pagination_type == 'category')
                            {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                            elseif ($this->pagination_type == 'archive')
                            {
                                if ($this->month != null){
                                    $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                                } else {
                                    $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                                }
                            }
                        }
                    }

                    $this->pagination .= '<div class="pagination dots">...</div>';

                    for ($p = (int) ($this->total_pages - 1); $p <= $this->total_pages; $p++)
                    {
                        if ($this->pagination_type == 'category')
                        {
                            $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                        }
                        elseif ($this->pagination_type == 'archive')
                        {
                            if ($this->month != null){
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                            } else {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                        }
                    }
                }
                
                
                // Current page is in the middle so we will brake the pagination from both sides
                elseif ($this->current_page > 4 && $this->current_page < (int) ($this->total_pages - 3))
                {
                    for ($p = 1; $p <= 2; $p++)
                    {
                        if ($this->pagination_type == 'category')
                        {
                            $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                        }
                        elseif ($this->pagination_type == 'archive')
                        {
                            if ($this->month != null){
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                            } else {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                        }
                    }

                    $this->pagination .= '<div class="pagination dots">...</div>';

                    for ($p = (int) ($this->current_page - 1); $p <= (int) ($this->current_page + 1); $p++)
                    {
                        if ($p == $this->current_page)
                        {
                            $this->pagination .= '<div class="pagination current"><span class="pagination-link">' . $this->html_before_current_page . $p . $this->html_after_current_page . '</span></div>';
                        }
                        else
                        {
                            if ($this->pagination_type == 'category')
                            {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                            elseif ($this->pagination_type == 'archive')
                            {
                                if ($this->month != null){
                                    $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                                } else {
                                    $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                                }
                            }
                        }
                    }

                    $this->pagination .= '<div class="pagination dots">...</div>';

                    for ($p = (int) ($this->total_pages - 1); $p <= $this->total_pages; $p++)
                    {
                        if ($this->pagination_type == 'category')
                        {
                            $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                        }
                        elseif ($this->pagination_type == 'archive')
                        {
                            if ($this->month != null){
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                            } else {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                        }
                        
                    }
                }
                                
                
                // Current page is close to end so we will show the last 5 links at all times and break the begining of the pagination
                elseif ($this->current_page >= (int) ($this->total_pages - 3))
                {
                    for ($p = 1; $p <= 2; $p++)
                    {
                        if ($this->pagination_type == 'category')
                        {
                            $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                        }
                        elseif ($this->pagination_type == 'archive')
                        {
                            if ($this->month != null){
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                            } else {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                        }
                        
                    }

                    $this->pagination .= '<div class="pagination dots">...</div>';

                    for ($p = (int) ($this->total_pages - 4); $p <= $this->total_pages; $p++)
                    {
                        if ($p == $this->current_page)
                        {
                            $this->pagination .= '<div class="pagination current"><span class="pagination-link">' . $this->html_before_current_page . $p . $this->html_after_current_page . '</span></div>';
                        }
                        else
                        {
                        
                        if ($this->pagination_type == 'category')
                        {
                            $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => $p)) . '">' . $p . '</a></div>';
                        }
                        elseif ($this->pagination_type == 'archive')
                        {
                            if ($this->month != null){
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => $p)) . '">' . $p . '</a></div>';
                            } else {
                                $this->pagination .= '<div class="pagination page-' . $p . '"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => $p)) . '">' . $p . '</a></div>';
                            }
                        }
                        }
                    }
                }
            }

            // Next page link
            if ((int) ($this->current_page + 1) <= $this->total_pages)
            {
                if ($this->pagination_type == 'category')
                {
                    $this->pagination .= '<div class="pagination next"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'category', array('id_wpblog_cats' => $this->id_wpblog_cats, 'rewrite' => $this->rewrite, 'p' => (int) ($this->current_page + 1))) . '">' . $this->next_button_text . '</a></div>';
                }
                elseif ($this->pagination_type == 'archive')
                {
                    if ($this->month != null){
                        $this->pagination .= '<div class="pagination next"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => $this->month, 'p' => (int) ($this->current_page + 1))) . '">' . $this->next_button_text . '</a></div>';
                    } else {
                        $this->pagination .= '<div class="pagination next"><a class="pagination-link" href="' . $this->context->link->getModuleLink('wpblog', 'archive', array('year' => $this->year, 'month' => 'all', 'p' => (int) ($this->current_page + 1))) . '">' . $this->next_button_text . '</a></div>';
                    }
                }
                
            }
            else
            {
                $this->pagination .= '<div class="pagination next disabled"><span class="pagination-link">' . $this->next_button_text . '<span></div>';
            }

            return $this->pagination;
        }
    }

}
