<?php

class AdminWPBlogCommentsController extends ModuleAdminController
{
    
    public function __construct()
    {
        $this->className = 'WPBlogCommentModel';
        $this->table = 'wpblog_post_comments';
		$this->meta_title = $this->l('WP Blog - Comments');
        $this->deleted = false;
   		$this->explicitSelect = true;
        $this->context = Context::getContext();
        $this->multiple_fieldsets = true;
        $this->bootstrap = true;

        $this->addRowAction('edit');
        $this->addRowAction('delete');

        $this->bulk_actions = array(
            'delete' => array('text' => $this->l('Delete selected'),
            'icon' => 'icon-trash',
            'confirm' => $this->l('Are you sure you want to delete selected comments?')
        ));
                
        $this->fields_list = array(
            'id_wpblog_post_comments' => array(
                'title' => $this->l('ID'),
                'type' => 'int',
                'align' => 'center',
                'width' => 25
            ),
            'id_reply_to' => array(
                'title' => $this->l('Reply to'),
                'type' => 'int',
                'align' => 'center',
                'width' => 45
            ),
            'name' => array(
                'title' => $this->l('Name'),
                'width' => 250
            ),
            'email' => array(
                'title' => $this->l('E-mail'),
                'width' => 250
            ),
            'comment' => array(
                'title' => $this->l('Comment'),
                'width' => 'auto'
            ),
            'active' => array(
                'title' => $this->l('Status'),
                'width' => 70,
                'active' => 'status',
                'align' => 'center',
                'type' => 'bool'
            )
        );
                
        parent::__construct();
        
    }

    /* ------------------------------------------------------------- */
    /*  INCLUDE NECESSARY FILES
    /* ------------------------------------------------------------- */
    public function setMedia()
    {
        parent::setMedia();
        $this->addCSS(__PS_BASE_URI__.'modules/wpblog/views/css/admin/wpblog.css');
    }

    /* ------------------------------------------------------------- */
    /*  INIT TOOLBAR
    /* ------------------------------------------------------------- */
    public function initToolbar()
    {
        // Intentionally left blank! This is necessary for removing toolbar buttons.
    }
    
    /* ------------------------------------------------------------- */
    /*  RENDER ADD/EDIT FORM
    /* ------------------------------------------------------------- */
    public function renderForm()
    {
        $id_lang = $this->context->language->id;
        $obj = $this->loadObject(true);
       
        // Init Fields form array
        $this->fields_form = array(
            'wpblog-comment' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Comment'),
                        'icon' => 'icon-edit'
                    ),
                    'input' => array(
                        array(
                            'type' => 'text',
                            'name' => 'id_wpblog_posts',
                            'label' => $this->l('Post'),
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'text',
                            'name' => 'id_customer',
                            'label' => $this->l('Customer'),
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'text',
                            'name' => 'name',
                            'label' => $this->l('Name'),
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'text',
                            'name' => 'email',
                            'label' => $this->l('E-mail'),
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'text',
                            'name' => 'ip',
                            'label' => $this->l('IP Address'),
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'textarea',
                            'label' => $this->l('Comment'),
                            'name' => 'comment',
                            'cols' => 75,
                            'rows' => 7,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Displayed'),
                            'name' => 'active',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'active_on',
                                    'value' => 1,
                                    'label' => $this->l('Enabled')
                                ),
                                array(
                                    'id' => 'active_off',
                                    'value' => 0,
                                    'label' => $this->l('Disabled')
                                )
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'savePostComment'
                    )
                )
            )
        );
        
        $wpBlogPost = new WPBlogPostModel($obj->id_wpblog_posts, $id_lang);
        
        $this->tpl_form_vars = array(
            'customerLink' => $this->context->link->getAdminLink('AdminCustomers'),
            'blogPostLink' => $this->context->link->getAdminLink('AdminWPBlogPosts'),
            'blogPostName' => $wpBlogPost->name
        );
        
        return parent::renderForm();
        
    }
        
}
