<?php

/* Withinpixels - Autumn Theme Configuration - 2014 - Sercan YEMEN - twitter.com/sercan */

if (!defined('_PS_VERSION_'))
    exit;

include_once(_PS_MODULE_DIR_ . 'wpautumn/model/wpAutumnModel.php');

class WPAutumn extends Module
{
    private $_output = '';

    private $_standardConfig = '';
    private $_styleConfig = '';
    private $_multiLangConfig = '';

    private $_bgImageConfig = '';
    private $_fontConfig = '';

    private $_cssRules = array();
    private $_configDefaults = array();
    private $_websafeFonts = array();
    private $_googleFonts = array();

    function __construct()
    {
        $this->name = 'wpautumn';
        $this->tab = 'front_office_features';
        $this->version = '2.4.5';
        $this->author = 'Sercan YEMEN';
        $this->need_instance = 0;
        $this->secure_key = Tools::encrypt($this->name);
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('Withinpixels - Autumn Theme Configuration');
        $this->description = $this->l('Required by Autumn Theme');

        $this->_defineArrays();
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function install()
    {
        if (Shop::isFeatureActive()) {
            Shop::setContext(Shop::CONTEXT_ALL);
        }

        return parent::install()
        && $this->registerHook('displayHeader')
        && $this->registerHook('displayFooter')
        && $this->registerHook('quickImageViewer')
        && $this->_createConfigs()
        && $this->_createTab();
    }

    /* ------------------------------------------------------------- */
    /*  UNINSTALL THE MODULE
    /* ------------------------------------------------------------- */
    public function uninstall()
    {
        return parent::uninstall()
        && $this->unregisterHook('displayHeader')
        && $this->unregisterHook('displayFooter')
        && $this->unregisterHook('quickImageViewer')
        && $this->_deleteConfigs()
        && $this->_deleteTab();
    }

    /* ------------------------------------------------------------- */
    /*  CREATE THE TABLES
    /* ------------------------------------------------------------- */
    private function _createTables()
    {
        return true;
    }

    /* ------------------------------------------------------------- */
    /*  DELETE THE TABLES
    /* ------------------------------------------------------------- */
    private function _deleteTables()
    {
        return true;
    }

    /* ------------------------------------------------------------- */
    /*  CREATE CONFIGS
    /* ------------------------------------------------------------- */
    private function _createConfigs()
    {
        $languages = $this->context->language->getLanguages();

        foreach ($languages as $language) {
            $customHeaderText[$language['id_lang']] = 'Welcome to our store!';
        }

        foreach ($languages as $language) {
            $customFooterText[$language['id_lang']] = 'Autumn - Responsive Prestashop Theme © 2014';
        }

        // General Options
        $response = Configuration::updateValue('WPAC_mainLayout', 'fullwidth');
        $response &= Configuration::updateValue('WPAC_sidebarPosition', 'left');
        $response &= Configuration::updateValue('WPAC_gridColumnSize', 4);
        $response &= Configuration::updateValue('WPAC_enableRetina', 1);
        $response &= Configuration::updateValue('WPAC_enableCountdownTimer', 1);

        // Header Options
        $response &= Configuration::updateValue('WPAC_headerStyle', 'header-v1');
        $response &= Configuration::updateValue('WPAC_stickyMenu', 0);
        $response &= Configuration::updateValue('WPAC_stickyMenuUserInfo', 0);
        $response &= Configuration::updateValue('WPAC_customHeaderText', $customHeaderText);
        $response &= Configuration::updateValue('WPAC_headerTopBgColor', '#3c3c3c');
        $response &= Configuration::updateValue('WPAC_headerTopTxtColor', '#ffffff');
        $response &= Configuration::updateValue('WPAC_headerMainBgColor', '#fafafa');
        $response &= Configuration::updateValue('WPAC_headerMainTxtColor', '#565b64');

        // Footer Options
        $response &= Configuration::updateValue('WPAC_footerColumnCount', 4);
        $response &= Configuration::updateValue('WPAC_customFooterText', $customFooterText);
        $response &= Configuration::updateValue('WPAC_secondaryFooter', 0);
        $response &= Configuration::updateValue('WPAC_footerMainBgColor', '#2a2a2a');
        $response &= Configuration::updateValue('WPAC_footerBottomBgColor', '#3c3c3c');

        // Category Page Options
        $response &= Configuration::updateValue('WPAC_quickView', 1);
        $response &= Configuration::updateValue('WPAC_quickImageViewer', 1);
        $response &= Configuration::updateValue('WPAC_quickImageViewerAutoNext', 1);
        $response &= Configuration::updateValue('WPAC_categoryHeaderStyle', 'left|right');
        $response &= Configuration::updateValue('WPAC_subcategories', 0);
        $response &= Configuration::updateValue('WPAC_categoryViewType', 'grid');
        $response &= Configuration::updateValue('WPAC_categoryShowAvgRating', 0);
        $response &= Configuration::updateValue('WPAC_categoryShowColorOptions', 0);
        $response &= Configuration::updateValue('WPAC_categoryShowStockInfo', 0);

        // Product Page Options
        $response &= Configuration::updateValue('WPAC_enableProductNav', 1);
        $response &= Configuration::updateValue('WPAC_productShowReference', 1);
        $response &= Configuration::updateValue('WPAC_productShowCondition', 1);
        $response &= Configuration::updateValue('WPAC_productShowManName', 1);

        // Font Options
        $response &= Configuration::updateValue('WPAC_includeCyrillicSubset', 0);
        $response &= Configuration::updateValue('WPAC_includeGreekSubset', 0);
        $response &= Configuration::updateValue('WPAC_includeVietnameseSubset', 0);
        $response &= Configuration::updateValue('WPAC_mainFont', 'Open Sans');

        // Color Options
        $response &= Configuration::updateValue('WPAC_mainColorScheme', '#da3b44');

        // Background Options
        $response &= Configuration::updateValue('WPAC_backgroundColor', '#f2f2f2');
        $response &= Configuration::updateValue('WPAC_backgroundImage', '');
        $response &= Configuration::updateValue('WPAC_backgroundRepeat', 'repeat');
        $response &= Configuration::updateValue('WPAC_backgroundAttachment', 'scroll');
        $response &= Configuration::updateValue('WPAC_backgroundSize', 'auto');

        $response &= Configuration::updateValue('WPAC_bodyBackgroundColor', '#f2f2f2');
        $response &= Configuration::updateValue('WPAC_bodyBackgroundImage', '');
        $response &= Configuration::updateValue('WPAC_bodyBackgroundRepeat', 'repeat');
        $response &= Configuration::updateValue('WPAC_bodyBackgroundAttachment', 'scroll');
        $response &= Configuration::updateValue('WPAC_bodyBackgroundSize', 'auto');

        // Custom Codes
        $response &= Configuration::updateValue('WPAC_customCSS', '');
        $response &= Configuration::updateValue('WPAC_customJS', '');

        // Override Options
        $response &= Configuration::updateValue('PS_TC_ACTIVE', 0);
        $response &= Configuration::updateValue('PS_QUICK_VIEW', 1);

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  DELETE CONFIGS
    /* ------------------------------------------------------------- */
    private function _deleteConfigs()
    {
        // General Options
        $response = Configuration::deleteByName('WPAC_mainLayout');
        $response &= Configuration::deleteByName('WPAC_sidebarPosition');
        $response &= Configuration::deleteByName('WPAC_gridColumnSize');
        $response &= Configuration::deleteByName('WPAC_enableRetina');
        $response &= Configuration::deleteByName('WPAC_enableCountdownTimer');

        // Header Options
        $response &= Configuration::deleteByName('WPAC_headerStyle');
        $response &= Configuration::deleteByName('WPAC_stickyMenu');
        $response &= Configuration::deleteByName('WPAC_stickyMenuUserInfo');
        $response &= Configuration::deleteByName('WPAC_customHeaderText');
        $response &= Configuration::deleteByName('WPAC_headerTopBgColor');
        $response &= Configuration::deleteByName('WPAC_headerTopTxtColor');
        $response &= Configuration::deleteByName('WPAC_headerMainBgColor');
        $response &= Configuration::deleteByName('WPAC_headerMainTxtColor');

        // Footer Options
        $response &= Configuration::deleteByName('WPAC_footerColumnCount');
        $response &= Configuration::deleteByName('WPAC_customFooterText');
        $response &= Configuration::deleteByName('WPAC_secondaryFooter');
        $response &= Configuration::deleteByName('WPAC_footerMainBgColor');
        $response &= Configuration::deleteByName('WPAC_footerBottomBgColor');

        // Category Page Options
        $response &= Configuration::deleteByName('WPAC_quickImageViewer');
        $response &= Configuration::deleteByName('WPAC_quickImageViewerAutoNext');
        $response &= Configuration::deleteByName('WPAC_quickView');
        $response &= Configuration::deleteByName('WPAC_categoryHeaderStyle');
        $response &= Configuration::deleteByName('WPAC_subcategories');
        $response &= Configuration::deleteByName('WPAC_categoryViewType');
        $response &= Configuration::deleteByName('WPAC_categoryShowAvgRating');
        $response &= Configuration::deleteByName('WPAC_categoryShowColorOptions');
        $response &= Configuration::deleteByName('WPAC_categoryShowStockInfo');

        // Product Page Options
        $response &= Configuration::deleteByName('WPAC_enableProductNav');
        $response &= Configuration::deleteByName('WPAC_productShowReference');
        $response &= Configuration::deleteByName('WPAC_productShowCondition');
        $response &= Configuration::deleteByName('WPAC_productShowManName');

        // Font Options
        $response &= Configuration::deleteByName('WPAC_includeCyrillicSubset');
        $response &= Configuration::deleteByName('WPAC_includeGreekSubset');
        $response &= Configuration::deleteByName('WPAC_includeVietnameseSubset');
        $response &= Configuration::deleteByName('WPAC_mainFont');

        // Color Options
        $response &= Configuration::deleteByName('WPAC_mainColorScheme');

        // Background Options
        $response &= Configuration::deleteByName('WPAC_backgroundColor');
        $response &= Configuration::deleteByName('WPAC_backgroundImage');
        $response &= Configuration::deleteByName('WPAC_backgroundRepeat');
        $response &= Configuration::deleteByName('WPAC_backgroundAttachment');
        $response &= Configuration::deleteByName('WPAC_backgroundSize');

        $response &= Configuration::deleteByName('WPAC_bodyBackgroundColor');
        $response &= Configuration::deleteByName('WPAC_bodyBackgroundImage');
        $response &= Configuration::deleteByName('WPAC_bodyBackgroundRepeat');
        $response &= Configuration::deleteByName('WPAC_bodyBackgroundAttachment');
        $response &= Configuration::deleteByName('WPAC_bodyBackgroundSize');

        // Custom Codes
        $response &= Configuration::deleteByName('WPAC_customCSS');
        $response &= Configuration::deleteByName('WPAC_customJS');

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  INSTALL DEMO DATA
    /* ------------------------------------------------------------- */
    private function _installDemoData()
    {
        return true;
    }

    /* ------------------------------------------------------------- */
    /*  CREATE THE TAB MENU
    /* ------------------------------------------------------------- */
    private function _createTab()
    {
        $response = true;

        // First check for parent tab
        $parentTabID = Tab::getIdFromClassName('AdminWP');

        if ($parentTabID) {
            $parentTab = new Tab($parentTabID);
        }
        else {
            $parentTab = new Tab();
            $parentTab->active = 1;
            $parentTab->name = array();
            $parentTab->class_name = "AdminWP";
            foreach (Language::getLanguages() as $lang) {
                $parentTab->name[$lang['id_lang']] = "WithinPixels";
            }
            $parentTab->id_parent = 0;
            $parentTab->module = $this->name;
            $response &= $parentTab->add();
        }

        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = "AdminWPAutumnConfig";
        $tab->name = array();
        foreach (Language::getLanguages() as $lang) {
            $tab->name[$lang['id_lang']] = "Autumn Theme Configuration";
        }
        $tab->id_parent = $parentTab->id;
        $tab->module = $this->name;
        $response &= $tab->add();

        return $response;
    }

    /* ------------------------------------------------------------- */
    /*  DELETE THE TAB MENU
    /* ------------------------------------------------------------- */
    private function _deleteTab()
    {
        $id_tab = Tab::getIdFromClassName('AdminWPAutumnConfig');
        $parentTabID = Tab::getIdFromClassName('AdminWP');

        $tab = new Tab($id_tab);
        $tab->delete();

        // Get the number of tabs inside our parent tab
        // If there is no tabs, remove the parent
        $tabCount = Tab::getNbTabs($parentTabID);
        if ($tabCount == 0) {
            $parentTab = new Tab($parentTabID);
            $parentTab->delete();
        }

        return true;
    }

    /* ------------------------------------------------------------- */
    /*  DEFINE ARRAYS
    /* ------------------------------------------------------------- */
    private function _defineArrays()
    {
        $bgImageDir = $this->context->link->getMediaLink(_MODULE_DIR_ . $this->name . '/views/img/front/bg/');

        // CONFIG ARRAYS
        $this->_standardConfig = array(
            // General Options
            'WPAC_mainLayout',
            'WPAC_sidebarPosition',
            'WPAC_gridColumnSize',
            'WPAC_enableRetina',
            'WPAC_enableCountdownTimer',

            // Header Options
            'WPAC_headerStyle',
            'WPAC_stickyMenu',
            'WPAC_stickyMenuUserInfo',

            // Footer Options
            'WPAC_footerColumnCount',
            'WPAC_secondaryFooter',

            // Category Page Options
            'WPAC_quickImageViewer',
            'WPAC_quickImageViewerAutoNext',
            'WPAC_quickView',
            'WPAC_categoryHeaderStyle',
            'WPAC_subcategories',
            'WPAC_categoryViewType',
            'WPAC_categoryShowAvgRating',
            'WPAC_categoryShowColorOptions',
            'WPAC_categoryShowStockInfo',

            // Product Page Options
            'WPAC_enableProductNav',
            'WPAC_productShowReference',
            'WPAC_productShowCondition',
            'WPAC_productShowManName',

            // Font Options
            'WPAC_includeCyrillicSubset',
            'WPAC_includeGreekSubset',
            'WPAC_includeVietnameseSubset'
        );

        $this->_styleConfig = array(
            // Header Options
            'WPAC_headerTopBgColor',
            'WPAC_headerTopTxtColor',
            'WPAC_headerMainBgColor',
            'WPAC_headerMainTxtColor',

            // Footer Options
            'WPAC_footerMainBgColor',
            'WPAC_footerBottomBgColor',

            // Background Options
            'WPAC_backgroundColor',
            'WPAC_backgroundImage',
            'WPAC_backgroundRepeat',
            'WPAC_backgroundAttachment',
            'WPAC_backgroundSize',

            'WPAC_bodyBackgroundColor',
            'WPAC_bodyBackgroundImage',
            'WPAC_bodyBackgroundRepeat',
            'WPAC_bodyBackgroundAttachment',
            'WPAC_bodyBackgroundSize',

            // Font Options
            'WPAC_mainFont',

            // Color Options
            'WPAC_mainColorScheme',

            // Custom Codes
            'WPAC_customCSS',
            'WPAC_customJS'
        );

        $this->_multiLangConfig = array(
            // Header Options
            'WPAC_customHeaderText',
            'WPAC_customFooterText'
        );

        // SPECIAL ARRAYS
        // These arrays are only for defining certain config values that needs to be handled differently.
        $this->_bgImageConfig = array(
            'WPAC_backgroundImage',
            'WPAC_bodyBackgroundImage'
        );

        $this->_fontConfig = array(
            'WPAC_mainFont',
        );
        // End - SPECIAL ARRAYS

        // CSS AND CONFIG RELATIONS
        $this->_cssRules = array(
            // #wrapper Background
            'WPAC_backgroundColor' => array(
                array(
                    'selector' => '#wrapper',
                    'rule' => 'background-color'
                )
            ),
            'WPAC_backgroundImage' => array(
                array(
                    'selector' => '#wrapper',
                    'rule' => 'background-image',
                    'prefix' => 'url("' . $bgImageDir,
                    'suffix' => '")'
                )
            ),
            'WPAC_backgroundRepeat' => array(
                array(
                    'selector' => '#wrapper',
                    'rule' => 'background-repeat'
                )
            ),
            'WPAC_backgroundAttachment' => array(
                array(
                    'selector' => '#wrapper',
                    'rule' => 'background-attachment'
                )
            ),
            'WPAC_backgroundSize' => array(
                array(
                    'selector' => '#wrapper',
                    'rule' => 'background-size'
                )
            ),

            // Body Background
            'WPAC_bodyBackgroundColor' => array(
                array(
                    'selector' => 'body',
                    'rule' => 'background-color'
                )
            ),
            'WPAC_bodyBackgroundImage' => array(
                array(
                    'selector' => 'body',
                    'rule' => 'background-image',
                    'prefix' => 'url("' . $bgImageDir,
                    'suffix' => '")'
                )
            ),
            'WPAC_bodyBackgroundRepeat' => array(
                array(
                    'selector' => 'body',
                    'rule' => 'background-repeat'
                )
            ),
            'WPAC_bodyBackgroundAttachment' => array(
                array(
                    'selector' => 'body',
                    'rule' => 'background-attachment'
                )
            ),
            'WPAC_bodyBackgroundSize' => array(
                array(
                    'selector' => 'body',
                    'rule' => 'background-size'
                )
            ),

            // Header
            'WPAC_headerTopBgColor' => array(
                array(
                    'selector' => '#header_top',
                    'rule' => 'background-color'
                )
            ),
            'WPAC_headerTopTxtColor' => array(
                array(
                    'selector' => '#header_top',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#header_top a',
                    'rule' => 'color'
                ),
            ),
            'WPAC_headerMainBgColor' => array(
                array(
                    'selector' => '#header_bottom',
                    'rule' => 'background-color'
                )
            ),
            'WPAC_headerMainTxtColor' => array(
                /* wpmegamenu */
                array(
                    'selector' => '#header_bottom .wpmegamenu .root-item > .title',
                    'rule' => 'color'
                ),
                /* search */
                array(
                    'selector' => '.search_query_icon',
                    'rule' => 'color'
                ),
                /* cart info */
                array(
                    'selector' => '.cart_info .wpicon-cart',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#header_shopping_cart .cart_info > a',
                    'rule' => 'color'
                ),
            ),

            // Footer
            'WPAC_footerMainBgColor' => array(
                array(
                    'selector' => '#footer',
                    'rule' => 'background-color'
                )
            ),
            'WPAC_footerBottomBgColor' => array(
                array(
                    'selector' => '#bottom-footer',
                    'rule' => 'background-color'
                ),
                array(
                    'selector' => '#footer-social-links',
                    'rule' => 'background-color'
                )
            ),

            // Font
            'WPAC_mainFont' => array(
                array(
                    'selector' => 'body',
                    'rule' => 'font-family'
                )
            ),

            // Main Color Scheme
            'WPAC_mainColorScheme' => array(
                //layout.css
                array(
                    'selector' => '.grid .item-price',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.grid .item-tag-new',
                    'rule' => 'background'
                ),

                //autumn.css
                array(
                    'selector' => 'a:hover',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.colored-text',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.iconed-text > .wpicon',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.colored-bg',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '.price',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.required sup, sup.required',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.button-1.fill',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '.button-1.flat',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '.no-touch .button-1.outline:hover',
                    'rule' => 'border-color'
                ),
                array(
                    'selector' => '.no-touch .button-1.outline:hover',
                    'rule' => 'background',
                    'suffix' => '!important'
                ),
                array(
                    'selector' => '.no-touch .button-3:hover',
                    'rule' => 'background',
                    'suffix' => '!important'
                ),
                array(
                    'selector' => 'h3.section-header',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.tabs .tab-title.active',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.tabs .tab-title.active',
                    'rule' => 'border-color'
                ),
                array(
                    'selector' => '.tabs .tab-contents .tab-content-wrapper.active .tab-title',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.tabs .tab-contents .tab-content-wrapper.active .tab-title',
                    'rule' => 'border-color'
                ),
                array(
                    'selector' => '#header_shopping_cart .wpicon-cart',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#categories_block_left li a.selected',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#layered_block_left .layered_subtitle',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.ui-slider-horizontal .ui-slider-range',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '.no-touch .tags_block a:hover',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '#currency_selector .currencies_ul li.selected',
                    'rule' => 'background-color'
                ),
                array(
                    'selector' => '#language_selector .languages_ul li.selected',
                    'rule' => 'background-color'
                ),
                array(
                    'selector' => '#category-header',
                    'rule' => 'background-color'
                ),
                array(
                    'selector' => '.sortPagiBar .category-view-type > a.active',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.no-touch .grid .item-quick-image-viewer-buttons > div:hover',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#product_comparison .on_sale',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.pb-left-column #image-block .new',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '.secondary_block .page-product-heading',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#product_comparison .discount',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.myaccount-link-list .item .wpicon',
                    'rule' => 'color'
                ),
                array(
                    'selector' => 'ul.step li.step_done',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '.cart_product_contains > #summary_products_quantity',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#cart_summary .cart_total_price #total_price_container #total_price_label',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '#order_step .step_done',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '#order-opc .order-opc-section-title > .number',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '.no-touch #product_comments_block_tab span.report_btn:hover',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.no-touch #secondary-footer a:hover',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#footer a:hover',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.block .title_block',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.block h4',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.block .title_block a',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.block h4 a',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '#go-to-top',
                    'rule' => 'background'
                ),
                array(
                    'selector' => '#mobile-header-toggle',
                    'rule' => 'background'
                ),

                //wpmegamenu.css
                array(
                    'selector' => '.wpmegamenu .menu-items',
                    'rule' => 'border-color'
                ),

                array(
                    'selector' => '.no-touch .wpmegamenu .root:hover .root-item > .title',
                    'rule' => 'color'
                ),

                // wpisotopetabs.css
                array(
                    'selector' => '.no-touch #wpisotopetabs .wpisotopetabs-filter a:hover',
                    'rule' => 'background',
                    'suffix' => '!important'
                ),
                array(
                    'selector' => '#wpisotopetabs .wpisotopetabs-filter a.active',
                    'rule' => 'background',
                    'suffix' => '!important'
                ),

                //wpsearchblock.css
                array(
                    'selector' => '.wpsearchblock-open .search_query_icon, .search_query_icon:hover',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.ac_results .ac_product_name strong',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.ac_results .ac_over',
                    'rule' => 'background',
                    'suffix' => '!important'
                ),
                array(
                    'selector' => '.ac_results.mobile .ac_product_name strong',
                    'rule' => 'color'
                ),
                array(
                    'selector' => '.ac_results.mobile .ac_over',
                    'rule' => 'background',
                    'suffix' => '!important'
                ),

                //wpmobilemenu
                array(
                    'selector' => '#wpmm-nav',
                    'rule' => 'background'
                ),

                //owl carousel
                array(
                    'selector' => '.owl-theme .owl-controls .owl-page span',
                    'rule' => 'background'
                )
            )
        );

        // Config defaults
        $this->_configDefaults = array(
            /* Header Options */
            'WPAC_headerTopBgColor' => '#3c3c3c',
            'WPAC_headerTopTxtColor' => '#ffffff',
            'WPAC_headerMainBgColor' => '#fafafa',
            'WPAC_headerMainTxtColor' => '#565b64',

            /* Footer Options */
            'WPAC_footerMainBgColor' => '#2a2a2a',
            'WPAC_footerBottomBgColor' => '#3c3c3c',
            'WPAC_mainColorScheme' => '#da3b44',

            /* Background Options */
            'WPAC_backgroundColor' => '#f2f2f2',
            'WPAC_backgroundRepeat' => 'repeat',
            'WPAC_backgroundAttachment' => 'scroll',
            'WPAC_backgroundSize' => 'auto',

            'WPAC_bodyBackgroundColor' => '#f2f2f2',
            'WPAC_bodyBackgroundRepeat' => 'repeat',
            'WPAC_bodyBackgroundAttachment' => 'scroll',
            'WPAC_bodyBackgroundSize' => 'auto'
        );

        // Web-safe Fonts
        $this->_websafeFonts = array('Arial', 'Helvetica', 'Verdana', 'Georgia', 'Times New Roman', 'sans-serif');

        // Google Fonts
        $this->_googleFonts = array(
            'ABeeZee' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Abel' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Abril Fatface' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Aclonica' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Acme' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Actor' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Adamina' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Advent Pro' => array('subsets' => array('latin', 'latin-ext', 'greek'), 'variants' => array('100', '200', '300', '400', '500', '600', '700')),
            'Aguafina Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Akronim' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Aladin' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Aldrich' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Alef' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Alegreya' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic', '900', '900italic')),
            'Alegreya SC' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic', '900', '900italic')),
            'Alegreya Sans' => array('subsets' => array('latin', 'latin-ext', 'vietnamese'), 'variants' => array('100', '100italic', '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic')),
            'Alegreya Sans SC' => array('subsets' => array('latin', 'latin-ext', 'vietnamese'), 'variants' => array('100', '100italic', '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic', '800', '800italic', '900', '900italic')),
            'Alex Brush' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Alfa Slab One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Alice' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Alike' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Alike Angular' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Allan' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Allerta' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Allerta Stencil' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Allura' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Almendra' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Almendra Display' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Almendra SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Amarante' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Amaranth' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Amatic SC' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Amethysta' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Anaheim' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Andada' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Andika' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Angkor' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Annie Use Your Telescope' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Anonymous Pro' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Antic' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Antic Didone' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Antic Slab' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Anton' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Arapey' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Arbutus' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Arbutus Slab' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Architects Daughter' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Archivo Black' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Archivo Narrow' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Arimo' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Arizonia' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Armata' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Artifika' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Arvo' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Asap' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Asset' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Astloch' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Asul' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Atomic Age' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Aubrey' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Audiowide' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Autour One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Average' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Average Sans' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Averia Gruesa Libre' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Averia Libre' => array('subsets' => array('latin'), 'variants' => array('300', '300italic', '400', 'italic', '700', '700italic')),
            'Averia Sans Libre' => array('subsets' => array('latin'), 'variants' => array('300', '300italic', '400', 'italic', '700', '700italic')),
            'Averia Serif Libre' => array('subsets' => array('latin'), 'variants' => array('300', '300italic', '400', 'italic', '700', '700italic')),
            'Bad Script' => array('subsets' => array('cyrillic', 'latin'), 'variants' => array('400')),
            'Balthazar' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Bangers' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Basic' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Battambang' => array('subsets' => array('khmer'), 'variants' => array('400', '700')),
            'Baumans' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Bayon' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Belgrano' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Belleza' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'BenchNine' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '400', '700')),
            'Bentham' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Berkshire Swash' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Bevan' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Bigelow Rules' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Bigshot One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Bilbo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Bilbo Swash Caps' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Bitter' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700')),
            'Black Ops One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Bokor' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Bonbon' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Boogaloo' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Bowlby One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Bowlby One SC' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Brawler' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Bree Serif' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Bubblegum Sans' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Bubbler One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Buda' => array('subsets' => array('latin'), 'variants' => array('300')),
            'Buenard' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Butcherman' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Butterfly Kids' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Cabin' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic')),
            'Cabin Condensed' => array('subsets' => array('latin'), 'variants' => array('400', '500', '600', '700')),
            'Cabin Sketch' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Caesar Dressing' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Cagliostro' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Calligraffitti' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Cambo' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Candal' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Cantarell' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Cantata One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Cantora One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Capriola' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Cardo' => array('subsets' => array('greek-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('400', 'italic', '700')),
            'Carme' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Carrois Gothic' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Carrois Gothic SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Carter One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Caudex' => array('subsets' => array('greek-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Cedarville Cursive' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Ceviche One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Changa One' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Chango' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Chau Philomene One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Chela One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Chelsea Market' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Chenla' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Cherry Cream Soda' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Cherry Swash' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Chewy' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Chicle' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Chivo' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '900', '900italic')),
            'Cinzel' => array('subsets' => array('latin'), 'variants' => array('400', '700', '900')),
            'Cinzel Decorative' => array('subsets' => array('latin'), 'variants' => array('400', '700', '900')),
            'Clicker Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Coda' => array('subsets' => array('latin'), 'variants' => array('400', '800')),
            'Coda Caption' => array('subsets' => array('latin'), 'variants' => array('800')),
            'Codystar' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '400')),
            'Combo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Comfortaa' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('300', '400', '700')),
            'Coming Soon' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Concert One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Condiment' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Content' => array('subsets' => array('khmer'), 'variants' => array('400', '700')),
            'Contrail One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Convergence' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Cookie' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Copse' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Corben' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Courgette' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Cousine' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Coustard' => array('subsets' => array('latin'), 'variants' => array('400', '900')),
            'Covered By Your Grace' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Crafty Girls' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Creepster' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Crete Round' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Crimson Text' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '600', '600italic', '700', '700italic')),
            'Croissant One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Crushed' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Cuprum' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Cutive' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Cutive Mono' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Damion' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Dancing Script' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Dangrek' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Dawning of a New Day' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Days One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Delius' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Delius Swash Caps' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Delius Unicase' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Della Respira' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Denk One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Devonshire' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Didact Gothic' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('400')),
            'Diplomata' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Diplomata SC' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Domine' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Donegal One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Doppio One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Dorsa' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Dosis' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('200', '300', '400', '500', '600', '700', '800')),
            'Dr Sugiyama' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Droid Sans' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Droid Sans Mono' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Droid Serif' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Duru Sans' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Dynalight' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'EB Garamond' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese'), 'variants' => array('400')),
            'Eagle Lake' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Eater' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Economica' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Electrolize' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Elsie' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '900')),
            'Elsie Swash Caps' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '900')),
            'Emblema One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Emilys Candy' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Engagement' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Englebert' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Enriqueta' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Erica One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Esteban' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Euphoria Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ewert' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Exo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('100', '100italic', '200', '200italic', '300', '300italic', '400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic')),
            'Exo 2' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('100', '100italic', '200', '200italic', '300', '300italic', '400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic', '800', '800italic', '900', '900italic')),
            'Expletus Sans' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '500', '500italic', '600', '600italic', '700', '700italic')),
            'Fanwood Text' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Fascinate' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Fascinate Inline' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Faster One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Fasthand' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Fauna One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Federant' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Federo' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Felipa' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Fenix' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Finger Paint' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Fjalla One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Fjord One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Flamenco' => array('subsets' => array('latin'), 'variants' => array('300', '400')),
            'Flavors' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Fondamento' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Fontdiner Swanky' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Forum' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Francois One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Freckle Face' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Fredericka the Great' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Fredoka One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Freehand' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Fresca' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Frijole' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Fruktur' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Fugaz One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'GFS Didot' => array('subsets' => array('greek'), 'variants' => array('400')),
            'GFS Neohellenic' => array('subsets' => array('greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Gabriela' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Gafata' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Galdeano' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Galindo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Gentium Basic' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Gentium Book Basic' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Geo' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Geostar' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Geostar Fill' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Germania One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Gilda Display' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Give You Glory' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Glass Antiqua' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Glegoo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Gloria Hallelujah' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Goblin One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Gochi Hand' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Gorditas' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Goudy Bookletter 1911' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Graduate' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Grand Hotel' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Gravitas One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Great Vibes' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Griffy' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Gruppo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Gudea' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700')),
            'Habibi' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Hammersmith One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Hanalei' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Hanalei Fill' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Handlee' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Hanuman' => array('subsets' => array('khmer'), 'variants' => array('400', '700')),
            'Happy Monkey' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Headland One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Henny Penny' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Herr Von Muellerhoff' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Holtwood One SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Homemade Apple' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Homenaje' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'IM Fell DW Pica' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'IM Fell DW Pica SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'IM Fell Double Pica' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'IM Fell Double Pica SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'IM Fell English' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'IM Fell English SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'IM Fell French Canon' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'IM Fell French Canon SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'IM Fell Great Primer' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'IM Fell Great Primer SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Iceberg' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Iceland' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Imprima' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Inconsolata' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Inder' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Indie Flower' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Inika' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Irish Grover' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Istok Web' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Italiana' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Italianno' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Jacques Francois' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Jacques Francois Shadow' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Jim Nightshade' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Jockey One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Jolly Lodger' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Josefin Sans' => array('subsets' => array('latin'), 'variants' => array('100', '100italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic')),
            'Josefin Slab' => array('subsets' => array('latin'), 'variants' => array('100', '100italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic')),
            'Joti One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Judson' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700')),
            'Julee' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Julius Sans One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Junge' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Jura' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('300', '400', '500', '600')),
            'Just Another Hand' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Just Me Again Down Here' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Kameron' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Kantumruy' => array('subsets' => array('khmer'), 'variants' => array('300', '400', '700')),
            'Karla' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Kaushan Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Kavoon' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Kdam Thmor' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Keania One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Kelly Slab' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Kenia' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Khmer' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Kite One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Knewave' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Kotta One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Koulen' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Kranky' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Kreon' => array('subsets' => array('latin'), 'variants' => array('300', '400', '700')),
            'Kristi' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Krona One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'La Belle Aurore' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Lancelot' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Lato' => array('subsets' => array('latin'), 'variants' => array('100', '100italic', '300', '300italic', '400', 'italic', '700', '700italic', '900', '900italic')),
            'League Script' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Leckerli One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Ledger' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Lekton' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700')),
            'Lemon' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Libre Baskerville' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700')),
            'Life Savers' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Lilita One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Lily Script One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Limelight' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Linden Hill' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Lobster' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Lobster Two' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Londrina Outline' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Londrina Shadow' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Londrina Sketch' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Londrina Solid' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Lora' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Love Ya Like A Sister' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Loved by the King' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Lovers Quarrel' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Luckiest Guy' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Lusitana' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Lustria' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Macondo' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Macondo Swash Caps' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Magra' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Maiden Orange' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Mako' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Marcellus' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Marcellus SC' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Marck Script' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Margarine' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Marko One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Marmelad' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Marvel' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Mate' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Mate SC' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Maven Pro' => array('subsets' => array('latin'), 'variants' => array('400', '500', '700', '900')),
            'McLaren' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Meddon' => array('subsets' => array('latin'), 'variants' => array('400')),
            'MedievalSharp' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Medula One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Megrim' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Meie Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Merienda' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Merienda One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Merriweather' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '300italic', '400', 'italic', '700', '700italic', '900', '900italic')),
            'Merriweather Sans' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '300italic', '400', 'italic', '700', '700italic', '800', '800italic')),
            'Metal' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Metal Mania' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Metamorphous' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Metrophobic' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Michroma' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Milonga' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Miltonian' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Miltonian Tattoo' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Miniver' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Miss Fajardose' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Modern Antiqua' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Molengo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Molle' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('italic')),
            'Monda' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Monofett' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Monoton' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Monsieur La Doulaise' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Montaga' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Montez' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Montserrat' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Montserrat Alternates' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Montserrat Subrayada' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Moul' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Moulpali' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Mountains of Christmas' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Mouse Memoirs' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Mr Bedfort' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Mr Dafoe' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Mr De Haviland' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Mrs Saint Delafield' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Mrs Sheppards' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Muli' => array('subsets' => array('latin'), 'variants' => array('300', '300italic', '400', 'italic')),
            'Mystery Quest' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Neucha' => array('subsets' => array('cyrillic', 'latin'), 'variants' => array('400')),
            'Neuton' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('200', '300', '400', 'italic', '700', '800')),
            'New Rocker' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'News Cycle' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Niconne' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Nixie One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nobile' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Nokora' => array('subsets' => array('khmer'), 'variants' => array('400', '700')),
            'Norican' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Nosifer' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Nothing You Could Do' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Noticia Text' => array('subsets' => array('latin', 'latin-ext', 'vietnamese'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Noto Sans' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Noto Serif' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Nova Cut' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nova Flat' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nova Mono' => array('subsets' => array('latin', 'greek'), 'variants' => array('400')),
            'Nova Oval' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nova Round' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nova Script' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nova Slim' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nova Square' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Numans' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Nunito' => array('subsets' => array('latin'), 'variants' => array('300', '400', '700')),
            'Odor Mean Chey' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Offside' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Old Standard TT' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700')),
            'Oldenburg' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Oleo Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Oleo Script Swash Caps' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Open Sans' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic', '800', '800italic')),
            'Open Sans Condensed' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('300', '300italic', '700')),
            'Oranienbaum' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Orbitron' => array('subsets' => array('latin'), 'variants' => array('400', '500', '700', '900')),
            'Oregano' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Orienta' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Original Surfer' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Oswald' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '400', '700')),
            'Over the Rainbow' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Overlock' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic', '900', '900italic')),
            'Overlock SC' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ovo' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Oxygen' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '400', '700')),
            'Oxygen Mono' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'PT Mono' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400')),
            'PT Sans' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'PT Sans Caption' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400', '700')),
            'PT Sans Narrow' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400', '700')),
            'PT Serif' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'PT Serif Caption' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Pacifico' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Paprika' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Parisienne' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Passero One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Passion One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700', '900')),
            'Pathway Gothic One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Patrick Hand' => array('subsets' => array('latin', 'latin-ext', 'vietnamese'), 'variants' => array('400')),
            'Patrick Hand SC' => array('subsets' => array('latin', 'latin-ext', 'vietnamese'), 'variants' => array('400')),
            'Patua One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Paytone One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Peralta' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Permanent Marker' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Petit Formal Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Petrona' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Philosopher' => array('subsets' => array('cyrillic', 'latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Piedra' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Pinyon Script' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Pirata One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Plaster' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Play' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('400', '700')),
            'Playball' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Playfair Display' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic', '900', '900italic')),
            'Playfair Display SC' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic', '900', '900italic')),
            'Podkova' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Poiret One' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Poller One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Poly' => array('subsets' => array('latin'), 'variants' => array('400', 'italic')),
            'Pompiere' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Pontano Sans' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Port Lligat Sans' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Port Lligat Slab' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Prata' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Preahvihear' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Press Start 2P' => array('subsets' => array('cyrillic', 'latin', 'latin-ext', 'greek'), 'variants' => array('400')),
            'Princess Sofia' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Prociono' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Prosto One' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Puritan' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Purple Purse' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Quando' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Quantico' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Quattrocento' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Quattrocento Sans' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Questrial' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Quicksand' => array('subsets' => array('latin'), 'variants' => array('300', '400', '700')),
            'Quintessential' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Qwigley' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Racing Sans One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Radley' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Raleway' => array('subsets' => array('latin'), 'variants' => array('100', '200', '300', '400', '500', '600', '700', '800', '900')),
            'Raleway Dots' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Rambla' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Rammetto One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ranchers' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Rancho' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Rationale' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Redressed' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Reenie Beanie' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Revalia' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ribeye' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ribeye Marrow' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Righteous' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Risque' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Roboto' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('100', '100italic', '300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic', '900', '900italic')),
            'Roboto Condensed' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('300', '300italic', '400', 'italic', '700', '700italic')),
            'Roboto Slab' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('100', '300', '400', '700')),
            'Rochester' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Rock Salt' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Rokkitt' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Romanesco' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ropa Sans' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Rosario' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Rosarivo' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Rouge Script' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Ruda' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700', '900')),
            'Rufina' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Ruge Boogie' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ruluko' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Rum Raisin' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Ruslan Display' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Russo One' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Ruthie' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Rye' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Sacramento' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Sail' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Salsa' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Sanchez' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Sancreek' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Sansita One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Sarina' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Satisfy' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Scada' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Schoolbell' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Seaweed Script' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Sevillana' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Seymour One' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Shadows Into Light' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Shadows Into Light Two' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Shanti' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Share' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Share Tech' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Share Tech Mono' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Shojumaru' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Short Stack' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Siemreap' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Sigmar One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Signika' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '400', '600', '700')),
            'Signika Negative' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '400', '600', '700')),
            'Simonetta' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic', '900', '900italic')),
            'Sintony' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Sirin Stencil' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Six Caps' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Skranji' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '700')),
            'Slackey' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Smokum' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Smythe' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Sniglet' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', '800')),
            'Snippet' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Snowburst One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Sofadi One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Sofia' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Sonsie One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Sorts Mill Goudy' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400', 'italic')),
            'Source Code Pro' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('200', '300', '400', '500', '600', '700', '900')),
            'Source Sans Pro' => array('subsets' => array('latin', 'latin-ext', 'vietnamese'), 'variants' => array('200', '200italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic', '900', '900italic')),
            'Special Elite' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Spicy Rice' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Spinnaker' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Spirax' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Squada One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Stalemate' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Stalinist One' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Stardos Stencil' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Stint Ultra Condensed' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Stint Ultra Expanded' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Stoke' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('300', '400')),
            'Strait' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Sue Ellen Francisco' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Sunshiney' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Supermercado One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Suwannaphum' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Swanky and Moo Moo' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Syncopate' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Tangerine' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Taprom' => array('subsets' => array('khmer'), 'variants' => array('400')),
            'Tauri' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Telex' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Tenor Sans' => array('subsets' => array('cyrillic', 'cyrillic-ext', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Text Me One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'The Girl Next Door' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Tienne' => array('subsets' => array('latin'), 'variants' => array('400', '700', '900')),
            'Tinos' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'vietnamese', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Titan One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Titillium Web' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('200', '200italic', '300', '300italic', '400', 'italic', '600', '600italic', '700', '700italic', '900')),
            'Trade Winds' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Trocchi' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Trochut' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700')),
            'Trykker' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Tulpen One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Ubuntu' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('300', '300italic', '400', 'italic', '500', '500italic', '700', '700italic')),
            'Ubuntu Condensed' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('400')),
            'Ubuntu Mono' => array('subsets' => array('cyrillic', 'greek-ext', 'cyrillic-ext', 'latin', 'latin-ext', 'greek'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Ultra' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Uncial Antiqua' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Underdog' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Unica One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'UnifrakturCook' => array('subsets' => array('latin'), 'variants' => array('700')),
            'UnifrakturMaguntia' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Unkempt' => array('subsets' => array('latin'), 'variants' => array('400', '700')),
            'Unlock' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Unna' => array('subsets' => array('latin'), 'variants' => array('400')),
            'VT323' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Vampiro One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Varela' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Varela Round' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Vast Shadow' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Vibur' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Vidaloka' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Viga' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Voces' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Volkhov' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Vollkorn' => array('subsets' => array('latin'), 'variants' => array('400', 'italic', '700', '700italic')),
            'Voltaire' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Waiting for the Sunrise' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Wallpoet' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Walter Turncoat' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Warnes' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Wellfleet' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Wendy One' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('400')),
            'Wire One' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Yanone Kaffeesatz' => array('subsets' => array('latin', 'latin-ext'), 'variants' => array('200', '300', '400', '700')),
            'Yellowtail' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Yeseva One' => array('subsets' => array('cyrillic', 'latin', 'latin-ext'), 'variants' => array('400')),
            'Yesteryear' => array('subsets' => array('latin'), 'variants' => array('400')),
            'Zeyada' => array('subsets' => array('latin'), 'variants' => array('400'))
        );

    }

    /* ------------------------------------------------------------- */
    /*  GET CONTENT
    /* ------------------------------------------------------------- */
    public function getContent()
    {
        $id_shop = $this->context->shop->id;
        $languages = $this->context->language->getLanguages();
        $errors = array();

        // Load css file for option panel
        $this->context->controller->addCSS(_MODULE_DIR_ . $this->name . '/views/css/admin/wpautumn-admin.css');

        // Load js file for option panel
        $this->context->controller->addJqueryPlugin('wpautumn', _MODULE_DIR_ . $this->name . '/views/js/admin/');

        if (Tools::isSubmit('submit' . $this->name)) {

            // Standard config
            foreach ($this->_standardConfig as $config) {
                if (Tools::isSubmit($config)) {
                    Configuration::updateValue($config, Tools::getValue($config));
                }
            }

            // Style config
            foreach ($this->_styleConfig as $config) {

                // Check if the config is a background image
                if (in_array($config, $this->_bgImageConfig)) {
                    if (isset($_FILES[$config]) && isset($_FILES[$config]['tmp_name']) && !empty($_FILES[$config]['tmp_name'])) {
                        if ($error = ImageManager::validateUpload($_FILES[$config], Tools::convertBytes(ini_get('upload_max_filesize')))) {
                            $errors[] = $error;
                        }
                        else {
                            $imageName = explode('.', $_FILES[$config]['name']);
                            $imageExt = $imageName[1];
                            $imageName = $imageName[0];
                            $backgroundImageName = $imageName . '-' . $id_shop . '.' . $imageExt;

                            if (!move_uploaded_file($_FILES[$config]['tmp_name'], _PS_MODULE_DIR_ . $this->name . '/views/img/front/bg/' . $backgroundImageName)) {
                                $errors[] = $this->l('File upload error.');
                            }
                            else {
                                Configuration::updateValue($config, $backgroundImageName);
                            }
                        }
                    }

                    continue;
                }

                if (Tools::isSubmit($config)) {
                    Configuration::updateValue($config, Tools::getValue($config));
                }

            }

            // Multilanguage config
            foreach ($this->_multiLangConfig as $config) {

                foreach ($languages as $language) {
                    if (Tools::isSubmit($config . '_' . $language['id_lang'])) {
                        $multilangConfig[$language['id_lang']] = Tools::getValue($config . '_' . $language['id_lang']);
                    }
                }

                if (is_array($multilangConfig) && $multilangConfig) {
                    Configuration::updateValue($config, $multilangConfig, true);
                }

                $multilangConfig = false;

            }

            // Custom Codes
            if (Tools::isSubmit('WPAC_customCSS')) {
                Configuration::updateValue('WPAC_customCSS', Tools::getValue('WPAC_customCSS'));
            }

            if (Tools::isSubmit('WPAC_customJS')) {
                Configuration::updateValue('WPAC_customJS', Tools::getValue('WPAC_customJS'));
            }

            // Write the configurations to a CSS file
            $response = $this->_writeCss();
            if (!$response) {
                $errors[] = $this->l('An error occured while writing the css file!');
            }

            // Prepare the output
            if (count($errors)) {
                $this->_output .= $this->displayError(implode('<br />', $errors));
            }
            else {
                $this->_output .= $this->displayConfirmation($this->l('Configuration updated'));
            }

        }
        elseif (Tools::isSubmit('deleteConfig')) {
            $config = Tools::getValue('deleteConfig');
            $configValue = Configuration::get($config);

            if (file_exists(_PS_MODULE_DIR_ . $this->name . '/views/img/front/bg/' . $configValue)) {
                unlink(_PS_MODULE_DIR_ . $this->name . '/views/img/front/bg/' . $configValue);
            }

            Configuration::updateValue($config, null);

        }
        elseif (Tools::isSubmit('mergeOldNewsletter') && Tools::getValue('mergeOldNewsletter') == 1) {
            $this->_mergeOldNewsletter();
        }

        return $this->_output . $this->_displayForm();
    }

    /* ------------------------------------------------------------- */
    /*  DISPLAY CONFIGURATION FORM
    /* ------------------------------------------------------------- */
    private function _displayForm()
    {
        $id_default_lang = $this->context->language->id;
        $languages = $this->context->language->getLanguages();
        $id_shop = $this->context->shop->id;

        // General Options
        $layoutTypes = array(
            array(
                'value' => 'fullwidth',
                'name' => 'FullWidth'
            ),
            array(
                'value' => 'boxed',
                'name' => 'Boxed'
            )
        );

        $sidebarPositions = array(
            array(
                'value' => 'left',
                'name' => 'Left'
            ),
            array(
                'value' => 'right',
                'name' => 'Right'
            )
        );

        $gridColumnSizes = array(
            array(
                'value' => 2,
                'name' => '2 products'
            ),
            array(
                'value' => 3,
                'name' => '3 products'
            ),
            array(
                'value' => 4,
                'name' => '4 products'
            ),
            array(
                'value' => 5,
                'name' => '5 products'
            ),
            array(
                'value' => 6,
                'name' => '6 products'
            )
        );

        // Header Options
        $headerStyles = array(
            array(
                'value' => 'header-v1',
                'name' => 'Header1'
            ),
            array(
                'value' => 'header-v2',
                'name' => 'Header2'
            ),
            array(
                'value' => 'header-v3',
                'name' => 'Header3'
            )
        );

        // Footer Options
        $footerColumnCounts = array(
            array(
                'value' => 2,
                'name' => '2 columns'
            ),
            array(
                'value' => 3,
                'name' => '3 columns'
            ),
            array(
                'value' => 4,
                'name' => '4 columns'
            ),
            array(
                'value' => 5,
                'name' => '5 columns'
            ),
            array(
                'value' => 6,
                'name' => '6 columns'
            )
        );

        // Category Page Options
        $categoryHeaderStyles = array(
            array(
                'value' => 'left|left',
                'name' => 'Title and Breadcrumb on the left'
            ),
            array(
                'value' => 'center|center',
                'name' => 'Title and Breadcrumb in the center'
            ),
            array(
                'value' => 'right|right',
                'name' => 'Title and Breadcrumb on the right'
            ),
            array(
                'value' => 'left|right',
                'name' => 'Title on the left - Breadcrumb on the right'
            ),
            array(
                'value' => 'right|left',
                'name' => 'Breadcrumb on the left - Title on the right'
            )
        );

        $categoryViewTypes = array(
            array(
                'value' => 'grid',
                'name' => 'Grid'
            ),
            array(
                'value' => 'list',
                'name' => 'List'
            )
        );

        // Background Options
        $backgroundRepeatOptions = array(
            array(
                'value' => 'repeat-x',
                'name' => 'Repeat-X'
            ),
            array(
                'value' => 'repeat-y',
                'name' => 'Repeat-Y'
            ),
            array(
                'value' => 'repeat',
                'name' => 'Repeat Both'
            ),
            array(
                'value' => 'no-repeat',
                'name' => 'No Repeat'
            )
        );

        $backgroundAttachmentOptions = array(
            array(
                'value' => 'scroll',
                'name' => 'Scroll'
            ),
            array(
                'value' => 'fixed',
                'name' => 'Fixed'
            )
        );

        $backgroundSizeOptions = array(
            array(
                'value' => 'auto',
                'name' => 'Auto'
            ),
            array(
                'value' => 'cover',
                'name' => 'Cover'
            )
        );

        // Font Options
        $fontOptions = array();

        foreach ($this->_websafeFonts as $fontName){
            $fontOptions[] = array(
                'value' => $fontName,
                'name' => $fontName
            );
        }

        foreach ($this->_googleFonts as $fontName => $fontInfo){
            $fontOptions[] = array(
                'value' => $fontName,
                'name' => $fontName
            );
        }


        $fields_form = array(
            'wpautumn-general' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('General'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_mainLayout',
                            'label' => $this->l('Layout type'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $layoutTypes,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_sidebarPosition',
                            'label' => $this->l('Sidebar position'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $sidebarPositions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_gridColumnSize',
                            'label' => $this->l('Number of products in one row'),
                            'desc' => $this->l('Only for "Grid" view. This option will adapt itself according to the screen resolution of the device.'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $gridColumnSizes,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'name' => 'WPAC_enableRetina',
                            'label' => $this->l('Enable Retina Images'),
                            'desc' => $this->l('This option enables/disables retina image support for product images. If you do not have retina images for your products, you should disable this option. Other elements such as fonts and icons will still have retina support.'),
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'retina_on',
                                    'value' => 1,
                                    'label' => $this->l('On')
                                ),
                                array(
                                    'id' => 'retina_off',
                                    'value' => 0,
                                    'label' => $this->l('Off')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'name' => 'WPAC_enableCountdownTimer',
                            'label' => $this->l('Enable Countdown Timers'),
                            'desc' => $this->l('This option enables/disables countdown timers for timed specific prices.'),
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'timer_on',
                                    'value' => 1,
                                    'label' => $this->l('On')
                                ),
                                array(
                                    'id' => 'timer_off',
                                    'value' => 0,
                                    'label' => $this->l('Off')
                                )
                            )
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-header' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Header'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_headerStyle',
                            'label' => $this->l('Header style'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $headerStyles,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Sticky menu'),
                            'name' => 'WPAC_stickyMenu',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'stickymenu_on',
                                    'value' => 1,
                                    'label' => $this->l('On')
                                ),
                                array(
                                    'id' => 'stickymenu_off',
                                    'value' => 0,
                                    'label' => $this->l('Off')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show user info on sticky menu'),
                            'name' => 'WPAC_stickyMenuUserInfo',
                            'desc' => $this->l('Show user name and login/logout links in sticky menu'),
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'stickymenuuserinfo_on',
                                    'value' => 1,
                                    'label' => $this->l('On')
                                ),
                                array(
                                    'id' => 'stickymenuuserinfo_off',
                                    'value' => 0,
                                    'label' => $this->l('Off')
                                )
                            )
                        ),
                        array(
                            'type' => 'text',
                            'name' => 'WPAC_customHeaderText',
                            'label' => $this->l('Custom header text'),
                            'required' => false,
                            'lang' => true,
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_headerTopBgColor',
                            'label' => $this->l('Header top section background color'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_headerTopTxtColor',
                            'label' => $this->l('Header top section text color'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_headerMainBgColor',
                            'label' => $this->l('Header main background color'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_headerMainTxtColor',
                            'label' => $this->l('Header main text color'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-footer' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Footer'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_footerColumnCount',
                            'label' => $this->l('Footer column count'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $footerColumnCounts,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'text',
                            'name' => 'WPAC_customFooterText',
                            'label' => $this->l('Custom footer text'),
                            'required' => false,
                            'lang' => true,
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_footerMainBgColor',
                            'label' => $this->l('Footer main background color'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_footerBottomBgColor',
                            'label' => $this->l('Footer bottom section background color'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-categorypages' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Category Pages'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_categoryHeaderStyle',
                            'label' => $this->l('Category header style'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $categoryHeaderStyles,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show subcategories'),
                            'name' => 'WPAC_subcategories',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'subcategories_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'subcategories_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_categoryViewType',
                            'label' => $this->l('Default category view type'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $categoryViewTypes,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Enable quick view'),
                            'name' => 'WPAC_quickView',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'quickview_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'quickview_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Enable quick image viewer'),
                            'name' => 'WPAC_quickImageViewer',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'quickimage_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'quickimage_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Slide to 2nd image automatically in quick image viewer on hover'),
                            'name' => 'WPAC_quickImageViewerAutoNext',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'quickimageautonext_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'quickimageautonext_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show average rating stars'),
                            'name' => 'WPAC_categoryShowAvgRating',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'avgratings_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'avgratings_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show color options'),
                            'name' => 'WPAC_categoryShowColorOptions',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'coloroptions_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'coloroptions_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show stock information'),
                            'name' => 'WPAC_categoryShowStockInfo',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'stockinfo_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'stockinfo_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-productpages' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Product Pages'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Enable Previous/Next Product buttons for product pages'),
                            'name' => 'WPAC_enableProductNav',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'productnav_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'productnav_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show product reference code'),
                            'name' => 'WPAC_productShowReference',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'productreference_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'productreference_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show product condition'),
                            'name' => 'WPAC_productShowCondition',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'productcondition_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'productcondition_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show product manufacturer name'),
                            'name' => 'WPAC_productShowManName',
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'productmanname_on',
                                    'value' => 1,
                                    'label' => $this->l('Yes')
                                ),
                                array(
                                    'id' => 'productmanname_off',
                                    'value' => 0,
                                    'label' => $this->l('No')
                                )
                            )
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-fonts' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Fonts'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'switch',
                            'name' => 'WPAC_includeCyrillicSubset',
                            'label' => $this->l('Include Cyrillic subsets'),
                            'desc' => $this->l('If the selected font has support for Cyrillic subset, Autumn will automatically include it if selected Yes. To see which fonts have Cyrillic subsets support: https://www.google.com/fonts'),
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'cyrillic_on',
                                    'value' => 1,
                                    'label' => $this->l('Include Cyrillic')
                                ),
                                array(
                                    'id' => 'cyrillic_off',
                                    'value' => 0,
                                    'label' => $this->l('Exclude Cyrillic')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'name' => 'WPAC_includeGreekSubset',
                            'label' => $this->l('Include Greek subsets'),
                            'desc' => $this->l('If the selected font has support for Greek subset, Autumn will automatically include it if selected Yes. To see which fonts have Greek subsets support: https://www.google.com/fonts'),
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'greek_on',
                                    'value' => 1,
                                    'label' => $this->l('Include Greek')
                                ),
                                array(
                                    'id' => 'greek_off',
                                    'value' => 0,
                                    'label' => $this->l('Exclude Greek')
                                )
                            )
                        ),
                        array(
                            'type' => 'switch',
                            'name' => 'WPAC_includeVietnameseSubset',
                            'label' => $this->l('Include Vietnamese subset'),
                            'desc' => $this->l('If the selected font has support for Vietnamese subset, Autumn will automatically include it if selected Yes. To see which fonts have Vietnamese subset support: https://www.google.com/fonts'),
                            'required' => false,
                            'is_bool' => true,
                            'values' => array(
                                array(
                                    'id' => 'vietnamese_on',
                                    'value' => 1,
                                    'label' => $this->l('Include Vietnamese')
                                ),
                                array(
                                    'id' => 'vietnamese_off',
                                    'value' => 0,
                                    'label' => $this->l('Exclude Vietnamese')
                                )
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_mainFont',
                            'label' => $this->l('Main Font Family'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $fontOptions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-colors' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Colors'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_mainColorScheme',
                            'label' => $this->l('Main color scheme'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-background' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Backgrounds'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_backgroundColor',
                            'label' => $this->l('Background color'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'file',
                            'name' => 'WPAC_backgroundImage',
                            'label' => $this->l('Background image'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_backgroundRepeat',
                            'label' => $this->l('Background repeat'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $backgroundRepeatOptions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_backgroundAttachment',
                            'label' => $this->l('Background attachment'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $backgroundAttachmentOptions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_backgroundSize',
                            'label' => $this->l('Background size'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $backgroundSizeOptions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'WPAC_bodyBackgroundColor',
                            'label' => $this->l('Body background color'),
                            'desc' => $this->l('Body background color only visible in "Boxed" mode.'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'file',
                            'name' => 'WPAC_bodyBackgroundImage',
                            'label' => $this->l('Body background image'),
                            'desc' => $this->l('Body background image only visible in "Boxed" mode.'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_bodyBackgroundRepeat',
                            'label' => $this->l('Body background repeat'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $backgroundRepeatOptions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_bodyBackgroundAttachment',
                            'label' => $this->l('Body background attachment'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $backgroundAttachmentOptions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        ),
                        array(
                            'type' => 'select',
                            'name' => 'WPAC_bodyBackgroundSize',
                            'label' => $this->l('Body background size'),
                            'required' => false,
                            'lang' => false,
                            'options' => array(
                                'query' => $backgroundSizeOptions,
                                'id' => 'value',
                                'name' => 'name'
                            )
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-codes' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Custom Codes'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'textarea',
                            'name' => 'WPAC_customCSS',
                            'desc' => $this->l('Important Note: Use this area if only there are rules you cannot override with using normal css files. This will add css rules as inline code and it is not the best practice. Try using "custom.css" file located under "themes/autumn/css/" folder to add your custom css rules.'),
                            'rows' => 10,
                            'label' => $this->l('Custom CSS Code'),
                            'required' => false,
                            'lang' => false
                        ),
                        array(
                            'type' => 'textarea',
                            'name' => 'WPAC_customJS',
                            'rows' => 10,
                            'label' => $this->l('Custom JS Code'),
                            'required' => false,
                            'lang' => false
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            ),
            'wpautumn-merge' => array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Data Merge'),
                        'icon' => 'icon-cog'
                    ),
                    'input' => array(
                        array(
                            'type' => 'text',
                            'name' => 'merge_oldnewsletter',
                            'label' => $this->l('Merge Newsletter Data'),
                            'size' => 20,
                            'required' => false,
                            'lang' => false
                        )
                    ),
                    // Submit Button
                    'submit' => array(
                        'title' => $this->l('Save'),
                        'name' => 'saveAutumnThemeConfig'
                    )
                )
            )
        );

        $helper = new HelperForm();

        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;

        $helper->default_form_language = $id_default_lang;
        $helper->allow_employee_form_lang = $id_default_lang;

        $helper->title = $this->displayName;
        $helper->show_toolbar = true;
        $helper->toolbar_scroll = true;
        $helper->submit_action = 'submit' . $this->name;
        $helper->toolbar_btn = array(
            'save' => array(
                'desc' => $this->l('Save'),
                'href' => AdminController::$currentIndex . '&configure=' . $this->name . '&save' . $this->name . '&token=' . Tools::getAdminTokenLite('AdminModules'),
            )
        );

        foreach ($languages as $language) {
            $helper->languages[] = array(
                'id_lang' => $language['id_lang'],
                'iso_code' => $language['iso_code'],
                'name' => $language['name'],
                'is_default' => ($id_default_lang == $language['id_lang'] ? 1 : 0)
            );
        }

        // Load standard field values
        foreach ($this->_standardConfig as $key => $standardField) {
            $helper->fields_value[$standardField] = Configuration::get($standardField);
        }

        // Load css field values
        foreach ($this->_styleConfig as $key => $cssField) {
            $helper->fields_value[$cssField] = Configuration::get($cssField);
        }

        // Load multi-language field values
        foreach ($this->_multiLangConfig as $key => $multiLangField) {
            foreach ($languages as $language) {
                $helper->fields_value[$multiLangField][$language['id_lang']] = Tools::getValue($multiLangField . '_' . $language['id_lang'], Configuration::get($multiLangField, $language['id_lang']));
            }
        }

        // MERGE OPTIONS
        //Check stuff for merge
        $oldNewsletterTableExists = false;
        if (Module::isInstalled('autumnnewsletterblock')) {
            $oldNewsletterTableExists = WPAutumnModel::checkAutumnNewsletterTable();
        }
        $newsletterInstalled = Module::isInstalled('blocknewsletter');

        // Custom variables
        $helper->tpl_vars = array(
            'wptabs' => $this->getTabs(),
            'oldNewsletterTableExists' => $oldNewsletterTableExists,
            'newsletterInstalled' => $newsletterInstalled,
            'imagePath' => _MODULE_DIR_ . $this->name . '/views/img/front/bg/',
            'shopId' => $id_shop
        );

        return $helper->generateForm($fields_form);
    }


    /* ------------------------------------------------------------- */
    /*  GET TABS
    /* ------------------------------------------------------------- */
    private function getTabs()
    {
        $tabArray = array(
            'General' => 'fieldset_wpautumn-general',
            'Header' => 'fieldset_wpautumn-header_1',
            'Footer' => 'fieldset_wpautumn-footer_2',
            'Category Pages' => 'fieldset_wpautumn-categorypages_3',
            'Product Pages' => 'fieldset_wpautumn-productpages_4',
            'Fonts' => 'fieldset_wpautumn-fonts_5',
            'Colors' => 'fieldset_wpautumn-colors_6',
            'Background' => 'fieldset_wpautumn-background_7',
            'Custom Codes' => 'fieldset_wpautumn-codes_8',
            'Data Merge' => 'fieldset_wpautumn-merge_9',
        );

        return $tabArray;
    }

    /* ------------------------------------------------------------- */
    /*  WRITE CSS
    /* ------------------------------------------------------------- */
    private function _writeCss()
    {
        $id_shop = $this->context->shop->id;

        $cssFile = _PS_MODULE_DIR_ . $this->name . '/views/css/front/configCss-' . $id_shop . '.css';
        $handle = fopen($cssFile, 'w');

        $config = $this->_getThemeConfig();

        // Starting of the cssCode
        $cssCode = '';

        // Read _cssRules and create css rules
        foreach ($this->_cssRules as $configName => $css) {

            // Check if the config is set, and it's not the default value
            if ($config[$configName] == '') {
                continue;
            }
            if (isset($this->_configDefaults[$configName]) && $config[$configName] == $this->_configDefaults[$configName]) {
                continue;
            }

            // If the config is a font config then do this and write the css rule for it
            if ( in_array($configName, $this->_fontConfig) ){

                // Check if the font is one of the web-safe fonts,
                // if it's then just write the basic font-family rule
                if ( in_array($config[$configName], $this->_websafeFonts) ){
                    foreach ($css as $line){
                        $cssCode .= $line['selector'] . '{' . $line['rule'] . ':' . (isset($line['prefix']) ? $line['prefix'] : '') . (isset($line['value']) ? $line['value'] : '"' . $config[$configName] . '", "sans-serif"') . (isset($line['suffix']) ? $line['suffix'] : '') . ';}';
                    }
                    continue;
                }

                // If not then do some preparations for google fonts
                // then write the proper css rule
                $googleFontName = str_replace(' ', '+', $config[$configName]);
                $googleFontSubsets = $this->_googleFonts[$config[$configName]]['subsets'];
                $googleFontVariants = $this->_googleFonts[$config[$configName]]['variants'];

                $isIncludeCyrillic = Configuration::get('WPAC_includeCyrillicSubset');
                $isIncludeGreek = Configuration::get('WPAC_includeCyrillicSubset');
                $isIncludeVietnamese = Configuration::get('WPAC_includeCyrillicSubset');

                $importCode = '@import "//fonts.googleapis.com/css?family='.$googleFontName;

                /* VARIANTS */
                // Include normal (400)
                $importCode .= ':400';

                // Include bold if available
                if ( in_array('700', $googleFontVariants) ){
                    $importCode .= ',700';
                }

                /* SUBSETS */
                // Include Latin and Latin-ext
                $importCode .= '&subset=latin,latin-ext';

                // Include Cyrillic subsets if they are selected and available for the font
                if ($isIncludeCyrillic){
                    if ( in_array('cyrillic', $googleFontSubsets) ){
                        $importCode .=',cyrillic';
                    }
                    if ( in_array('cyrillic-ext', $googleFontSubsets) ){
                        $importCode .=',cyrillic-ext';
                    }
                }

                // Include Greek subsets if they are selected and available for the font
                if ($isIncludeGreek){
                    if ( in_array('greek', $googleFontSubsets) ){
                        $importCode .=',greek';
                    }
                    if ( in_array('cyrillic-ext', $googleFontSubsets) ){
                        $importCode .=',greek-ext';
                    }
                }

                // Include Vietnamese subset if it is selected and available for the font
                if ($isIncludeVietnamese && in_array('vietnamese', $googleFontSubsets)){
                    $importCode .=',greek';
                }

                $importCode .= '";';

                $cssCode = $importCode . $cssCode;

                foreach ($css as $line){
                    $cssCode .= $line['selector'] . '{' . $line['rule'] . ':' . (isset($line['prefix']) ? $line['prefix'] : '') . (isset($line['value']) ? $line['value'] : '"' . $config[$configName] . '", "Helvetica", "Arial", "sans-serif"') . (isset($line['suffix']) ? $line['suffix'] : '') . ';}';
                }

                continue;
            }

            // Otherwise create the general css rule for it
            foreach ($css as $line) {
                $cssCode .= $line['selector'] . '{' . $line['rule'] . ':' . (isset($line['prefix']) ? $line['prefix'] : '') . (isset($line['value']) ? $line['value'] : $config[$configName]) . (isset($line['suffix']) ? $line['suffix'] : '') . ';}';
            }


        }

        $response = fwrite($handle, $cssCode);

        return $response;

    }

    /* ------------------------------------------------------------- */
    /*  GET THEME CONFIG
    /* ------------------------------------------------------------- */
    private function _getThemeConfig($standard = true, $style = true, $multiLang = true)
    {
        $id_default_lang = $this->context->language->id;

        $config = array();

        if ($standard) {
            foreach ($this->_standardConfig as $configItem) {
                $config[$configItem] = Configuration::get($configItem);
            }
        }

        if ($style) {
            foreach ($this->_styleConfig as $configItem) {
                $config[$configItem] = Configuration::get($configItem);
            }
        }

        if ($multiLang) {
            foreach ($this->_multiLangConfig as $configItem) {
                $config[$configItem] = Configuration::get($configItem, $id_default_lang);
            }
        }

        return $config;
    }

    /* ------------------------------------------------------------- */
    /*  MERGE OLD NEWSLETTER
    /* ------------------------------------------------------------- */
    private function _mergeOldNewsletter()
    {
        $oldNewsletterTableExists = WPAutumnModel::checkAutumnNewsletterTable();
        $newsletterInstalled = Module::isInstalled('blocknewsletter');

        if ($oldNewsletterTableExists && $newsletterInstalled) {
            $wpAutumn = new WPAutumnModel();
            $response = $wpAutumn->mergeOldNewsletterContent();

            Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules') . '&configure=wpautumn');
        }

        return false;
    }


    /* ------------------------------------------------------------- */
    /*
    /*  FRONT-OFFICE STUFF
    /*
    /* ------------------------------------------------------------- */

    /* ------------------------------------------------------------- */
    /*  PREPARE PRODUCT NAVIGATIONS
    /* ------------------------------------------------------------- */
    private function _prepProductNav()
    {
        $controller_name = Dispatcher::getInstance()->getController();
        $id_lang = $this->context->language->id;

        // First make sure we have all the stuff we need, so we can get the next/prev product links
        if ($controller_name != 'product' || !Tools::getIsset('id_product')) {
            return false;
        }

        $id_product = Tools::getValue('id_product');
        $product = new Product($id_product, false, $id_lang);

        if (!isset($this->context->cookie->last_visited_category) ||
            (isset($this->context->cookie->last_visited_category) && $this->context->cookie->last_visited_category == '') ||
            !Product::idIsOnCategoryId($id_product, array('0' => array('id_category' => $this->context->cookie->last_visited_category)))
        ) {
            $id_category = $product->id_category_default;
        }
        else {
            $id_category = $this->context->cookie->last_visited_category;
        }

        $productPos = WPAutumnModel::findProductPos($id_category, $id_product);
        $productMaxPos = WPAutumnModel::findProductMaxPos($id_category);
        if (!is_int($productPos) || !is_int($productMaxPos)) {
            return false;
        }

        // Try to get previous product
        $pos = $productPos - 1;

        if ($pos < 0) {
            $prevProductLink = 'firstItem';
        }
        else {
            for ($pos; $pos >= 0; $pos--) {
                $prevProductID = WPAutumnModel::getProductIdFromPos($id_category, $pos);
                $prevProduct = new Product($prevProductID, false, $id_lang);

                if (!$prevProduct->active) {
                    $prevProductLink = 'firstItem';
                    continue;
                }
                else {
                    $prevProductLink = $this->context->link->getProductLink($prevProduct);
                    break;
                }
            }
        }

        // Try to get next product
        $pos = $productPos + 1;

        if ($pos > $productMaxPos) {
            $nextProductLink = 'lastItem';
        }
        else {
            for ($pos; $pos <= $productMaxPos; $pos++) {
                $nextProductID = WPAutumnModel::getProductIdFromPos($id_category, $pos);
                $nextProduct = new Product($nextProductID, false, $id_lang);

                if (!$nextProduct->active) {
                    $nextProductLink = 'lastItem';
                    continue;
                }
                else {
                    $nextProductLink = $this->context->link->getProductLink($nextProduct);
                    break;
                }
            }
        }

        return array(
            'prev' => $prevProductLink,
            'next' => $nextProductLink
        );

    }

    /* ------------------------------------------------------------- */
    /*  PREPARE FOR HOOK
    /* ------------------------------------------------------------- */
    private function _prepHook($params)
    {
        $config = $this->_getThemeConfig();
        $controller_name = Dispatcher::getInstance()->getController();

        if ($config) {
            foreach ($config as $key => $value) {

                //Check cookies for category view type option
                if ($key == 'WPAC_categoryViewType') {
                    if (isset($this->context->cookie->category_view_type)) {
                        $this->smarty->assignGlobal($key, $this->context->cookie->category_view_type);
                        continue;
                    }
                }

                $this->smarty->assignGlobal($key, $value);
            }
        }

        /* WPAC_productNav */
        if (Configuration::get('WPAC_enableProductNav') == 1) {
            $productNavLinks = $this->_prepProductNav();
            if ($productNavLinks) {
                $this->smarty->assignGlobal('WPAC_productNavLinks', $productNavLinks);
            }
        }

        /* GLOBAL SMARTY VARS */

        /* Mobile menu my account */
        $has_address = $this->context->customer->getAddresses($this->context->language->id);
        $this->smarty->assignGlobal('WPMM_has_customer_an_address', empty($has_address));
        $this->smarty->assignGlobal('WPMM_voucherAllowed', CartRule::isFeatureActive());
        $this->smarty->assignGlobal('WPMM_returnAllowed', (int)Configuration::get('PS_ORDER_RETURN'));
        $this->smarty->assignGlobal('WPMM_HOOK_CUSTOMER_ACCOUNT', Hook::exec('displayCustomerAccount'));

        /* LOAD JS */

        // Load custom JS files
        $this->context->controller->addJqueryPlugin('plugins', _THEME_JS_DIR_ . 'autumn/');

        if (Module::isInstalled('blocklayered') && Module::isEnabled('blocklayered') && $controller_name == 'category') {
            $this->context->controller->addJqueryPlugin('ui.touch-punch.min', _THEME_JS_DIR_ . 'autumn/');
        }

        $this->context->controller->addJqueryPlugin('autumn', _THEME_JS_DIR_ . 'autumn/');

        return true;
    }


    /* ------------------------------------------------------------- */
    /*  HOOK (displayHeader)
    /* ------------------------------------------------------------- */
    public function hookDisplayHeader($params)
    {
        $this->_prepHook($params);
    }

    /* ------------------------------------------------------------- */
    /*  HOOK (displayFooter)
    /* ------------------------------------------------------------- */
    public function hookDisplayFooter($params)
    {
        $id_shop = $this->context->shop->id;

        /* We are loading css files in this hook, because
         * this is the only way to make sure these css files
         * will override any other css files.. Otherwise
         * module positioning will cause a lot of issues.
         */

        /* LOAD CSS */

        // Load custom CSS files
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'wp_framework/reset.css');
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'wp_framework/layout.css');
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'wp_framework/normalize.css');
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'wp_framework/iconfont.css');
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'autumn.css');
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'wp_framework/responsive.css');

        // DO NOT MOVE THIS -> see the file for more information
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'jquery_plugins/jquery.plugins.css');
        // DO NOT MOVE THIS

        // Load auto-created css files
        $cssFile = 'configCss-' . $id_shop . '.css';
        if (file_exists(_PS_MODULE_DIR_ . $this->name . '/views/css/front/' . $cssFile)) {
            $this->context->controller->addCSS(_MODULE_DIR_ . $this->name . '/views/css/front/' . $cssFile);
        }
        else {
            $this->context->controller->addCSS(_MODULE_DIR_ . $this->name . '/views/css/front/configCSS-default.css');
        }

        // Load custom.css file
        $this->context->controller->addCSS(_THEME_CSS_DIR_ . 'custom.css');
    }

    /* ------------------------------------------------------------- */
    /*  SCRIPT FOR hookQuickImageViewer
    /* ------------------------------------------------------------- */
    private function _quickImageScript()
    {
        $quickImageViewerScript = '
            <script type="text/javascript">
                $(window).load(function(){
                    if (WPAC_quickImageViewer == 1){
                        $(".item-images").each(function () {
                            initQuickImageViewer($(this));
                        });
                    }
                });
            </script>

        ';
        return $quickImageViewerScript;
    }

    /* ------------------------------------------------------------- */
    /*  CUSTOM HOOK (hookQuickImageViewer)
    /* ------------------------------------------------------------- */
    public function hookQuickImageViewer($params)
    {
        echo $this->_quickImageScript();
    }

}
