/**
* Module Prestashop CustomBlocks
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

function changeTab(name) {
	$('#tab_'+id_tab).removeClass('active');
	$('#tab_'+name).addClass('active');
	$('#content_'+id_tab).css('display', 'none');
	$('#content_'+name).css('display', 'block');
	id_tab = name;
	editAreaLoader.init({
		id: "contentCSS",
		syntax: "css",
		start_highlight: true,
		allow_resize: "no",
		allow_toggle: false,
		toolbar: "search, |, go_to_line, |, highlight"
	});
}

function nl2br(str, is_xhtml) {
    var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
    return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function loadFile(fileId) {
	getE('fileId').value = fileId;
	for (var i=0; i<=50; i++) {
		var fileName = getE('fileName_' + fileId).value;
	}
    var xhr;

	if (window.XMLHttpRequest) {
		xhr = new XMLHttpRequest();
	}
	else if (window.ActiveXObject) {
		try {
			xhr = new ActiveXObject("Msxml2.XMLHTTP");
		} catch (e) {
			try {
				xhr = new ActiveXObject("Microsoft.XMLHTTP");
			} catch (e) {}
		}
	}
	
	xhr.onreadystatechange = function() {
		if (xhr.readyState == 4 && xhr.status == 200) {
			var new_file= {id: fileId, text: xhr.responseText, syntax: 'css', title: fileName};
			editAreaLoader.openFile('contentCSS', new_file);
			getE('fileName').value = fileName;
		} else if (xhr.readyState == 4 && xhr.status != 200) {
			alert('Une erreur est survenue !\n\nCode :' + xhr.status + '\nTexte : ' + xhr.statusText);
		}
	};
 
   xhr.open("GET", baseDir + fileName + '?nocache=' + Math.random(), true);
   xhr.send(null);
}

function blockEdit(blockId) {
	getE('id').value = blockId;
	var hb = parseInt(getE('languageNb').value - 1);
	for (var i=0; i<=hb; i++) {
		tinyMCE.get('editorInput_' + blocks[blockId][i * 6]).setContent(blocks[blockId][i * 6 + 1]);
		getE('linkInput_' + blocks[blockId][i * 6]).value = blocks[blockId][i * 6 + 2];
		getE('inhookInput_' + blocks[blockId][i * 6]).value = blocks[blockId][i * 6 + 3];
		getE('positionInput_' + blocks[blockId][i * 6]).value = blocks[blockId][i * 6 + 4];
		getE('activeInput_' + blocks[blockId][i * 6]).value = blocks[blockId][i * 6 + 5];
	}

	if (document.all) {
		getE('submitAddBlock').style.setAttribute('cssText', 'display:none');
		getE('submitEditBlock').style.setAttribute('cssText', '');
	}
	getE('submitAddBlock').setAttribute('style', 'display:none');
	getE('submitEditBlock').setAttribute('style', '');
}

function blockDelete(blockId) {
	document.location.replace(currentUrl+'&id='+blockId+'&token='+token);
}