<?php
/**
* Module Prestashop CustomBlocks
*
* @author    Prestacrea
* @copyright Prestacrea
* @license   See PDF documentation
* @website   http://www.prestacrea.com
*/

class CustomBlocks extends Module
{
	public function __construct()
	{
		$this->name = 'customblocks';
		$this->tab = 'front_office_features';
		$this->version = '2.5.4';
		$this->author = 'PRESTACREA';

		$this->bootstrap = true;
		$this->need_instance = 0;
		parent::__construct();

		$this->displayName = ('PRESTACREA - Custom Blocks');
		$this->description = $this->l('Adds editable blocks on your shop');
		$this->confirmUninstall = $this->l('Uninstalling the module will delete all its data. Do you want to continue uninstalling the module ?');
        
        if (version_compare(_PS_VERSION_, '1.5.0.0', '<'))
            require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
	}

	public function install()
	{
		if (file_exists(dirname(__FILE__).'/install/customblocks-install.php'))
			require_once(dirname(__FILE__).'/install/customblocks-install.php');

		if (file_exists(dirname(__FILE__).'/views/css/front/less/default.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/views/css/front/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/responsive.less.cache');

		if (file_exists(dirname(__FILE__).'/install/customblocks-update.php') && $this->version >= '2.2')
			unlink(dirname(__FILE__).'/install/customblocks-update.php');

		if (!parent::install()
			|| !$this->registerHook('header')
			|| !$this->registerHook('top')
			|| !$this->registerHook('leftColumn')
			|| !$this->registerHook('rightColumn')
			|| !$this->registerHook('footer')
			|| !$this->registerHook('home')
			|| !$this->registerHook('extraLeft')
			|| !$this->registerHook('extraRight')
			|| !$this->registerHook('productActions')
			|| !$this->registerHook('productOutOfStock')
			|| !$this->registerHook('productfooter')
			|| !$this->registerHook('shoppingCart')
			|| !$this->registerHook('shoppingCartExtra')
			|| !$this->registerHook('createAccountForm')
			|| !$this->registerHook('customerAccount')
			|| !$this->registerHook('extraCarrier'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (file_exists(dirname(__FILE__).'/install/customblocks-uninstall.php'))
			require_once(dirname(__FILE__).'/install/customblocks-uninstall.php');

		if (file_exists(dirname(__FILE__).'/views/css/front/less/default.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/default.less.cache');
		if (file_exists(dirname(__FILE__).'/views/css/front/less/responsive.less.cache'))
			unlink(dirname(__FILE__).'/views/css/front/less/responsive.less.cache');

		if (!parent::uninstall())
			return false;
		return true;
	}

	public function addBlock()
	{
		$languages = Language::getLanguages();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'customblocks VALUES ()') || !$last_id = Db::getInstance()->Insert_ID())
				return false;
			foreach ($languages as $language) {
				$content = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$default_language);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$default_language);
				$inhook = Tools::getValue('inhook_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				$active = Tools::getValue('active_'.$default_language);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'customblocks_lang VALUES ('.$last_id.', \''.(int)$id_shop.'\', '.$language['id_lang'].', \''.addslashes($content).'\', \''.addslashes($link).'\', \''.addslashes($inhook).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
					return false;
			}
			return true;
		} else {
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'customblocks VALUES ()') || !$last_id = mysql_insert_id())
				return false;
			foreach ($languages as $language) {
				$content = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$default_language);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$default_language);
				$inhook = Tools::getValue('inhook_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				$active = Tools::getValue('active_'.$default_language);
				if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'customblocks_lang VALUES ('.$last_id.', "1", '.$language['id_lang'].', \''.addslashes($content).'\', \''.addslashes($link).'\', \''.addslashes($inhook).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
					return false;
			}
			return true;
		}
	}

	public function editBlock()
	{
		$languages = Language::getLanguages();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			foreach ($languages as $language) {
				$content = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$default_language);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$default_language);
				$inhook = Tools::getValue('inhook_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				$active = Tools::getValue('active_'.$default_language);
				$id_block = (int)Tools::getValue('id');
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'customblocks_lang VALUES (\''.($id_block).'\', \''.(int)$id_shop.'\', \''.$language['id_lang'].'\', \''.addslashes($content).'\', \''.addslashes($link).'\', \''.addslashes($inhook).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
					return false;
			}
			return true;
		} else {
			foreach ($languages as $language) {
				$content = Tools::getValue('editor_'.$language['id_lang']) ? Tools::getValue('editor_'.$language['id_lang']) : Tools::getValue('editor_'.$default_language);
				$link = Tools::getValue('link_'.$language['id_lang']) ? Tools::getValue('link_'.$language['id_lang']) : Tools::getValue('link_'.$default_language);
				$inhook = Tools::getValue('inhook_'.$default_language);
				$position = Tools::getValue('position_'.$default_language);
				$active = Tools::getValue('active_'.$default_language);
				$id_block = (int)Tools::getValue('id');
				if (!Db::getInstance()->Execute('REPLACE '._DB_PREFIX_.'customblocks_lang VALUES (\''.($id_block).'\', "1", \''.$language['id_lang'].'\', \''.addslashes($content).'\', \''.addslashes($link).'\', \''.addslashes($inhook).'\', \''.addslashes($position).'\', \''.addslashes($active).'\')'))
					return false;
			}
			return true;
		}
	}

	public function deleteBlock()
	{
		$id_block = (int)Tools::getValue('id');
		if (Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'customblocks WHERE `id_block`='.$id_block))
			return Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'customblocks_lang WHERE `id_block`='.$id_block);
		return false;
	}

	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.' - v.'.$this->version.'</h2>
		<div id="lnkDocContainer">
			<a class="lnk" target="_blank" href="'.$this->_path.'doc/'.$this->name.'.pdf">'.$this->l('PDF documentation').'</a>
		</div>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<input style="margin:0 0 20px;" type="submit" name="submitCache" value="'.$this->l('Clear module cache').'" class="button" />';
			if (file_exists(dirname(__FILE__).'/install/customblocks-update.php') && $this->version >= '2.2' && !Tools::isSubmit('submitUpdate'))
				$this->_html .= '<input style="margin:0 0 20px 10px;" type="submit" name="submitUpdate" value="'.$this->l('Update module').'" class="button" />';
		$this->_html .= '</form>';
		$default_language = Configuration::get('PS_LANG_DEFAULT');
		$position = Tools::getValue('position_'.$default_language);
		if (Tools::isSubmit('submitGeneral')) {
			Configuration::updateValue('CB_RESPONSIVE', pSQL(Tools::getValue('cb_responsive')));
			$this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
		} elseif (Tools::isSubmit('submitAddBlock')) {
			if (!$position || $position <= 0 || !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else {
				if ($this->addBlock())
					$this->_html .= $this->displayConfirmation($this->l('The block has been added successfully'));
				else
					$this->_html .= $this->displayError($this->l('An error occured during block adding'));
			}
		} elseif (Tools::isSubmit('submitEditBlock')) {
			if (!$position || $position <= 0 || !Validate::isInt($position))
				$this->_html .= $this->displayError($this->l('Invalid position number'));
			else {
				if (!Tools::getValue('id') || !is_numeric(Tools::getValue('id')) || !$this->editBlock())
					$this->_html .= $this->displayError($this->l('An error occured during block editing'));
				else
					$this->_html .= $this->displayConfirmation($this->l('The block has been edited successfully'));
			}
		} elseif (Tools::getValue('id')) {
			if (!is_numeric(Tools::getValue('id')) || !$this->deleteBlock())
				$this->_html .= $this->displayError($this->l('An error occurred during block deletion'));
			else
				$this->_html .= $this->displayConfirmation($this->l('The block has been deleted successfully'));
		}
		if (Tools::isSubmit('submitCSS')) {
			if ($this->putFileContents())
				$this->_html .= $this->displayConfirmation($this->l('CSS file updated'));
			else
				$this->_html .= $this->displayError($this->l('No CSS file selected'));
		}
		if (Tools::isSubmit('submitCache')) {
			if (file_exists(dirname(__FILE__).'/views/css/front/less/default.less.cache'))
				unlink(dirname(__FILE__).'/views/css/front/less/default.less.cache');
			if (file_exists(dirname(__FILE__).'/views/css/front/less/responsive.less.cache'))
				unlink(dirname(__FILE__).'/views/css/front/less/responsive.less.cache');
			$this->_html .= $this->displayConfirmation($this->l('Module cache cleared'));
		}
		if (Tools::isSubmit('submitUpdate')) {
			if (file_exists(dirname(__FILE__).'/install/customblocks-update.php'))
				require_once(dirname(__FILE__).'/install/customblocks-update.php');
			unlink(dirname(__FILE__).'/install/customblocks-update.php');
			$this->_html .= $this->displayConfirmation($this->l('Module updated'));
		}
		$this->displayForm();
		return $this->_html;
	}

	public function displayForm()
	{
		$iso = Language::getIsoById((int)$this->context->cookie->id_lang);
		$this->_html .= '<link rel="stylesheet" type="text/css" href="'.$this->_path.'views/css/admin/admin.css" />
		<script type="text/javascript" src="'.$this->_path.'views/js/admin/admin.js"></script>
		<script language="javascript" type="text/javascript" src="'.$this->_path.'views/js/admin/edit_area_full.js"></script>
		<div id="tab_container">
			<script type="text/javascript">var id_tab = 1;changeTab(id_tab);</script>
			<ul class="tabs">
				<li id="tab_1" class="tab active" onclick="changeTab(1);">'.$this->l('Blocks configuration').'</li>
				<li id="tab_2" class="tab" onclick="changeTab(2);">'.$this->l('General configuration').'</li>
				<li id="tab_3" class="tab" onclick="changeTab(3);">'.$this->l('CSS Editor').'</li>
			</ul>
			<div id="content_1" class="content" style="display:block">';
				$this->configBlocks();
			$this->_html .= '</div>
			<div id="content_2" class="content" style="display:none">';
				$this->configGeneral();
			$this->_html .= '</div>
			<div id="content_3" class="content" style="display:none">';
				$this->configCSS();
			$this->_html .= '</div>
		</div>';

		$iso_tiny_mce = (file_exists(_PS_ROOT_DIR_.'/js/tiny_mce/langs/'.$iso.'.js') ? $iso : 'en');
		$ad = dirname(Tools::safeOutput($_SERVER['PHP_SELF']));
		$this->_html .= '<script type="text/javascript">	
			var iso = \''.$iso_tiny_mce.'\' ;
			var pathCSS = \''._THEME_CSS_DIR_.'\' ;
			var ad = \''.$ad.'\' ;
		</script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tiny_mce/tiny_mce.js"></script>
		<script type="text/javascript" src="'.__PS_BASE_URI__.'js/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.6.0.12', '>='))
			$this->_html .= '<script type="text/javascript" src="'.__PS_BASE_URI__.'js/admin/tinymce.inc.js"></script>';
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->_html .= '<script type="text/javascript">
				$(document).ready(function(){
					tinySetup({
						theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
						theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
						theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
						theme_advanced_buttons4 : "styleprops,|,cite,abbr,acronym,del,ins,attribs,pagebreak",
						theme_advanced_resizing : false,
						relative_urls : false,
						convert_urls: false
					});
				});
			</script>';
		}
	}

	public function configBlocks()
	{
		$languages = Language::getLanguages();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$id_shop = $this->context->shop->id;
		$div_lang_name = 'editor¤link';
		$this->_html .= '<script type="text/javascript">id_language = Number('.$default_language.');</script>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data">
			<fieldset>
				<h3 id="blockedit_h3">'.$this->l('Blocks configuration').'</h3>
				<div id="blockedit" class="block auto block_item" style="margin-bottom:15px">
					<label>'.$this->l('Add or edit a block').'</label>
					<span class="label label_items">'.$this->l('Location').' :</span>
					<div>';
						foreach ($languages as $language) {
							$this->_html .= '<div id="inhook_'.$language['id_lang'].'" class="inhook" style="display:'.($language['id_lang'] == $default_language ? 'block' : 'none').'">
								<span>'.$this->l('Hook').'</span>
								<select name="inhook_'.$language['id_lang'].'" id="inhookInput_'.$language['id_lang'].'">
									<option value="top">'.$this->l('Top').'</option>
									<option value="leftColumn">'.$this->l('Left column').'</option>
									<option value="rightColumn">'.$this->l('Right column').'</option>
									<option value="footer">'.$this->l('Footer').'</option>
									<option value="home">'.$this->l('Homepage').'</option>
									<option value="extraLeft">'.$this->l('Product page left column').'</option>
									<option value="extraRight">'.$this->l('Product page right column').'</option>
									<option value="productActions">'.$this->l('Product page actions').'</option>
									<option value="productOutOfStock">'.$this->l('Product page out of stock').'</option>
									<option value="productfooter">'.$this->l('Product page footer').'</option>
									<option value="shoppingCart">'.$this->l('Shopping cart page footer').'</option>
									<option value="shoppingCartExtra">'.$this->l('Shopping cart page extra footer').'</option>
									<option value="createAccountForm">'.$this->l('Account creation page footer').'</option>
									<option value="customerAccount">'.$this->l('Customer account page').'</option>
									<option value="extraCarrier">'.$this->l('Carrier page').'</option>
									<option value="topColumn">'.$this->l('Top column (only for Prestacrea templates)').'</option>
								</select>
								<span style="margin-left:15px">'.$this->l('Position N&ordm;').'</span>
								<input type="text" size="1" maxlength="2" name="position_'.$language['id_lang'].'" id="positionInput_'.$language['id_lang'].'" value="" />
							</div>';
						}
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set the hook of the block and its position inside the hook').'</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Content').' :</span>
					<div class="editor_block">';
						foreach ($languages as $language)
						$this->_html .= '<div id="editor_'.$language['id_lang'].'" class="editor_items" style="display:'.($language['id_lang'] == $default_language ? 'block' : 'none').'">
							<textarea class="rte" cols="80" rows="30" id="editorInput_'.$language['id_lang'].'" name="editor_'.$language['id_lang'].'"></textarea>
						</div>';
						$this->_html .= $this->displayFlags($languages, $default_language, $div_lang_name, 'editor', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set the content of the block').'</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Link').' :</span>
					<div>';
						foreach ($languages as $language)
						$this->_html .= '<div id="link_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $default_language ? 'block' : 'none').';float:left">
							<input type="text" size="20" name="link_'.$language['id_lang'].'" id="linkInput_'.$language['id_lang'].'" value="" />
						</div>';
						$this->_html .= $this->displayFlags($languages, $default_language, $div_lang_name, 'link', true);
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Display a button with link in the block').'</p>
					<div class="space"></div>
					<span class="label label_items">'.$this->l('Status').' :</span>
					<div>';
						foreach ($languages as $language)
						$this->_html .= '<div id="active_'.$language['id_lang'].'" style="display:'.($language['id_lang'] == $default_language ? 'block' : 'none').';float:left">
							<select name="active_'.$language['id_lang'].'" id="activeInput_'.$language['id_lang'].'">
								<option value="1">'.$this->l('Enabled').'</option>
								<option value="0">'.$this->l('Disabled').'</option>
							</select>
						</div>';
					$this->_html .= '</div>
					<div class="clear"></div>
					<p class="legend_items">'.$this->l('Set whether the block is enabled or not').'</p>
					<div class="space"></div>';
					if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
						$this->_html .= '<input type="hidden" name="cb_id_shop" id="cb_id_shop" value="'.(int)$id_shop.'" />';
					else
						$this->_html .= '<input type="hidden" name="cb_id_shop" id="cb_id_shop" value="1" />';
					$this->_html .= '<input type="hidden" name="id" id="id" value="'.(Tools::getValue('id') ? Tools::getValue('id') : '').'" />
					<input type="submit" id="submitAddBlock" name="submitAddBlock" value="'.$this->l('Add this block').'" class="button" />
					<input type="submit" id="submitEditBlock" name="submitEditBlock" value="'.$this->l('Edit this block').'" class="button" style="display:none" />
				</div>
				<div class="block auto">';
					$this->listBlocks();
				$this->_html .= '</div>
			</fieldset>
		</form>';
	}

	public function configGeneral()
	{
		$this->_html .= '<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('General configuration options').'</h3>
				<div class="block auto">
					<label>'.$this->l('Activate responsive mode').'</label>
					<div class="inputContainer">
						<input type="radio" name="cb_responsive" value="1" '.(Configuration::get('CB_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('Yes').'
						<input type="radio" name="cb_responsive" value="0" '.(!Configuration::get('CB_RESPONSIVE') ? 'checked="checked"' : '').' />'.$this->l('No').'
					</div>
					<p>'.$this->l('Set whether the responsive mode is activated or not (the template used must be compatible, disable this option if the template is not responsive)').'</p>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitGeneral" value="'.$this->l('Update configuration').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function configCSS()
	{
		$dir = dirname(__FILE__).'/views/css/front/less/';
		$files = scandir($dir);
		$cnt = count($files);
		$this->_html .= '<script type="text/javascript">var baseDir = "'.$this->_path.'views/css/front/less/";</script>
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<h3>'.$this->l('Warning').'</h3>
				<div class="warning">'.$this->l('Editing CSS file is only for experienced users. Edit these files only if you know what you are doing.').'</div>
				<div class="clear"></div>
				<div class="space"></div>
				<h3>'.$this->l('List of CSS files (LESS files)').'</h3>
				<table class="table">
					<th>'.$this->l('Filename').'</th>
					<th class="center">'.$this->l('Edit').'</th>';
					for ($i = 0; $i < $cnt; $i++)
						if (preg_match('/.less$/', $files[$i])) {
							$link = '<a href="#editor_container" onclick="loadFile('.$i.');">';
							$link .= '<img src="'._PS_ADMIN_IMG_.'edit.gif" /></a>
							<input type="hidden" name="fileId" id="fileId" value="'.$i.'"/>
							<input type="hidden" name="fileName_'.$i.'" id="fileName_'.$i.'" value="'.$files[$i].'"/>';
							$this->_html .= '<tr>
								<td>'.$files[$i].'</td>
								<td class="center">'.$link.'</td>
							</tr>';
						}
				$this->_html .= '</table>
				<div>';
					$this->_html .= '<div id="editor_container">
						<textarea cols="80" rows="30" id="contentCSS" name="contentCSS"></textarea>
						<input type="hidden" name="fileName" id="fileName" value=""/>
					</div>
				</div>
				<div class="clear"></div>
				<div class="update"><input type="submit" name="submitCSS" value="'.$this->l('Update the CSS file').'" class="button" /></div>
			</fieldset>
		</form>';
	}

	public function putFileContents()
	{
		$filename = Tools::getValue('fileName');
		$file = dirname(__FILE__).'/views/css/front/less/'.$filename;
		$balises = array('content:"e', 'content:"f');
		$replace = array('content:"\\e', 'content:"\\f');
		$data = str_replace($balises, $replace, Tools::getValue('contentCSS'));
		$contents = $data;
		if ($filename) {
			file_put_contents($file, $contents);
			return true;
		} else
			return false;
	}

	public function getBlocks($id_lang = null)
	{
		$result = array();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			if (!$blocks = Db::getInstance()->ExecuteS('SELECT c.`id_block`, cl.`inhook`, cl.`position` FROM `'._DB_PREFIX_.'customblocks` c JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.') ORDER BY `inhook`, `position`'))
				return false;
		} else {
			if (!$blocks = Db::getInstance()->ExecuteS('SELECT c.`id_block`, cl.`inhook`, cl.`position` FROM `'._DB_PREFIX_.'customblocks` c JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.') ORDER BY `inhook`, `position`'))
				return false;
		}
		$i = 0;
		foreach ($blocks as $block) {
			$result[$i]['id'] = $block['id_block'];
			if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
				$sql = 'SELECT `id_lang`, `content`, `link`, `inhook`, `position`, `active` FROM '._DB_PREFIX_.'customblocks_lang WHERE `id_block`='.(int)$block['id_block'].' AND `id_shop`='.(int)$id_shop;
			else
				$sql = 'SELECT `id_lang`, `content`, `link`, `inhook`, `position`, `active` FROM '._DB_PREFIX_.'customblocks_lang WHERE `id_block`='.(int)$block['id_block'];
			if (isset($id_lang) && is_numeric($id_lang) && (int)$id_lang > 0)
				$sql .= ' AND `id_lang` = '.(int)$id_lang;
			if (!$texts = Db::getInstance()->ExecuteS($sql))
				return false;
			foreach ($texts as $text) {
				$result[$i]['content_'.$text['id_lang']] = $text['content'];
				$result[$i]['link_'.$text['id_lang']] = $text['link'];
				$result[$i]['inhook_'.$text['id_lang']] = $text['inhook'];
				$result[$i]['position_'.$text['id_lang']] = $text['position'];
				$result[$i]['active_'.$text['id_lang']] = $text['active'];
			}
			$i++;
		}
		return $result;
	}

	public function listBlocks()
	{
		$blocks = $this->getBlocks();
		$default_language = (int)Configuration::get('PS_LANG_DEFAULT');
		$languages = Language::getLanguages();
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
			$token = Tools::safeOutput(Tools::getValue('token'));
		if ($blocks) {
			$this->_html .= '<script type="text/javascript">
				var currentUrl = \''.Tools::safeOutput($_SERVER['REQUEST_URI']).'&configure='.$this->name.'\';';
				if (version_compare(_PS_VERSION_, '1.5.0.0', '>='))
					$this->_html .= 'var token=\''.$token.'\';';
				else
					$this->_html .= 'var token=\''.$this->context->admin_obj->token.'\';';
				$this->_html .= 'var blocks = new Array();';
				$var = '';
				foreach ($blocks as $block) {
					$var .= 'blocks['.$block['id'].'] = new Array(';
					$i = 0;
					foreach ($languages as $language) {
						if ($i > 0)
						$var .= ',';
						$var .= $language['id_lang'];
						$content = isset($block['content_'.$language['id_lang']]) ? $block['content_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes(str_replace(array("\r\n", "\r", "\n"), '', $content)).'\'';
						$link = isset($block['link_'.$language['id_lang']]) ? $block['link_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($link).'\'';
						$inhook = isset($block['inhook_'.$language['id_lang']]) ? $block['inhook_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($inhook).'\'';
						$position = isset($block['position_'.$language['id_lang']]) ? $block['position_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($position).'\'';
						$active = isset($block['active_'.$language['id_lang']]) ? $block['active_'.$language['id_lang']] : '';
						$var .= ',\''.addslashes($active).'\'';
						$i++;
					}
					$var .= ');';
				}
			$var .= '</script>';
			$this->_html .= $var;
		}

		if (!$blocks)
			$this->_html .= '<p style="font-size:12px;margin:0">'.$this->l('No blocks').'</p>';
		else {
			$this->_html .= '<table class="table table_items">
				<tr>
					<th class="table_id center" style="width:30px">'.$this->l('ID').'</th>
					<th class="table_hook center" style="width:60px">'.$this->l('Hook').'</th>
					<th class="table_position center" style="width:30px">'.$this->l('Position').'</th>
					<th class="table_content">'.$this->l('Content').'</th>
					<th class="table_link" style="width:120px">'.$this->l('Link').'</th>
					<th class="table_status center" style="width:60px">'.$this->l('Status').'</th>
					<th class="table_actions center" style="width:60px">'.$this->l('Actions').'</th>
				</tr>';
				$i = 0;
				foreach ($blocks as $block) {
					$content = isset($block['content_'.$this->context->cookie->id_lang]) ? $block['content_'.$this->context->cookie->id_lang] : $block['content_'.$default_language];
					$link = isset($block['link_'.$this->context->cookie->id_lang]) ? $block['link_'.$this->context->cookie->id_lang] : $block['link_'.$default_language];
					$inhook = isset($block['inhook_'.$this->context->cookie->id_lang]) ? $block['inhook_'.$this->context->cookie->id_lang] : $block['inhook_'.$default_language];
					$position = isset($block['position_'.$this->context->cookie->id_lang]) ? $block['position_'.$this->context->cookie->id_lang] : $block['position_'.$default_language];
					$active = isset($block['active_'.$this->context->cookie->id_lang]) ? $block['active_'.$this->context->cookie->id_lang] : $block['active_'.$default_language];
					$this->_html .= '<tr'.($i % 2 ? ' class="alternate"' : '').'>
						<td class="table_id center">'.(int)$block['id'].'</td>
						<td class="table_hook center">
							'.($inhook == 'top' ? ''.$this->l('Top').'' : '').'
							'.($inhook == 'leftColumn' ? ''.$this->l('Left column').'' : '').'
							'.($inhook == 'rightColumn' ? ''.$this->l('Right column').'' : '').'
							'.($inhook == 'footer' ? ''.$this->l('Footer').'' : '').'
							'.($inhook == 'home' ? ''.$this->l('Homepage').'' : '').'
							'.($inhook == 'extraLeft' ? ''.$this->l('Product page left column').'' : '').'
							'.($inhook == 'extraRight' ? ''.$this->l('Product page right column').'' : '').'
							'.($inhook == 'productActions' ? ''.$this->l('Product page actions').'' : '').'
							'.($inhook == 'productOutOfStock' ? ''.$this->l('Product page out of stock').'' : '').'
							'.($inhook == 'productfooter' ? ''.$this->l('Product page footer').'' : '').'
							'.($inhook == 'shoppingCart' ? ''.$this->l('Shopping cart page footer').'' : '').'
							'.($inhook == 'shoppingCartExtra' ? ''.$this->l('Shopping cart page extra footer').'' : '').'
							'.($inhook == 'createAccountForm' ? ''.$this->l('Account creation page footer').'' : '').'
							'.($inhook == 'customerAccount' ? ''.$this->l('Customer account page').'' : '').'
							'.($inhook == 'extraCarrier' ? ''.$this->l('Carrier page').'' : '').'
							'.($inhook == 'topColumn' ? ''.$this->l('Top column').'' : '').'
						</td>
						<td class="table_position center">'.(int)$position.'</td>
						<td class="table_content">'.$content.'</td>
						<td class="table_link">'.Tools::safeOutput($link).'</td>
						<td class="table_status center">'.($active == 1 ? '<img src="'._PS_ADMIN_IMG_.'enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" />' : '<img src="'._PS_ADMIN_IMG_.'disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" />').'</td>
						<td class="table_actions center">
							<a href="#blockedit_h3"><img src="'._PS_ADMIN_IMG_.'edit.gif" onclick="blockEdit('.$block['id'].')" style="padding:0" title="'.$this->l('Edit').'" /></a>
							<a href="#"><img src="'._PS_ADMIN_IMG_.'delete.gif" onclick="blockDelete('.$block['id'].');return false;" style="padding:0" title="'.$this->l('Delete').'" /></a>
						</td>
					</tr>';
					$i++;
				}
			$this->_html .= '</table>
			<input type="hidden" id="languageFirst" value="'.$languages[0]['id_lang'].'" />
			<input type="hidden" id="languageNb" value="'.count($languages).'" />';
		}
	}

	public function cacheCompileLess($input_file, $output_file)
	{
		if (!class_exists('lessc'))
			require_once dirname(__FILE__).'/lessc.inc.php';

		$cache_file = $input_file.'.cache';
		if (file_exists($cache_file))
			$cache = unserialize(Tools::file_get_contents($cache_file));
		else
			$cache = $input_file;

		$less = new lessc;

		$less->setFormatter('classic');
		$new_cache = $less->cachedCompile($cache);

		if (!is_array($cache) || $new_cache['updated'] > $cache['updated']) {
			file_put_contents($cache_file, serialize($new_cache));
			file_put_contents($output_file, $new_cache['compiled']);
		}
	}

	public function hookHeader()
	{
		$this->cacheCompileLess(dirname(__FILE__).'/views/css/front/less/default.less', dirname(__FILE__).'/views/css/front/customblocks.css');
		$this->cacheCompileLess(dirname(__FILE__).'/views/css/front/less/responsive.less', dirname(__FILE__).'/views/css/front/customblocks-responsive.css');

		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$this->context->controller->addCSS(($this->_path).'views/css/front/customblocks.css', 'all');
			if (Configuration::get('CB_RESPONSIVE') == 1)
				$this->context->controller->addCSS(($this->_path).'views/css/front/customblocks-responsive.css', 'all');
		} else {
			Tools::addCSS($this->_path.'views/css/front/customblocks.css', 'all');
			if (Configuration::get('CB_RESPONSIVE') == 1)
				Tools::addCSS($this->_path.'views/css/front/customblocks-responsive.css', 'all');
		}
	}

	public function hookTop()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "top"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "top"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'top'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookLeftColumn()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "leftColumn"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "leftColumn"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'leftColumn'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookRightColumn()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "rightColumn"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "rightColumn"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'rightColumn'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookFooter()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "footer"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "footer"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'footer'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookHome()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "home"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "home"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'home'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookExtraLeft()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "extraLeft"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "extraLeft"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'extraLeft'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookExtraRight()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "extraRight"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "extraRight"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'extraRight'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookProductActions()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "productActions"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "productActions"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'productActions'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookProductOutOfStock()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "productOutOfStock"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "productOutOfStock"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'productOutOfStock'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookProductFooter()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "productfooter"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "productfooter"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'productfooter'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookShoppingCart()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "shoppingCart"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "shoppingCart"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'shoppingCart'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookShoppingCartExtra()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "shoppingCartExtra"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "shoppingCartExtra"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'shoppingCartExtra'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookCreateAccountForm()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "createAccountForm"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "createAccountForm"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'createAccountForm'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookCustomerAccount()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "customerAccount"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "customerAccount"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'customerAccount'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookExtraCarrier()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "extraCarrier"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "extraCarrier"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'extraCarrier'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}

	public function hookTopColumn()
	{
		if (version_compare(_PS_VERSION_, '1.5.0.0', '>=')) {
			$id_shop = $this->context->shop->id;
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND `id_shop`='.(int)$id_shop.' AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "topColumn"
			AND `active` = 1
			ORDER BY `position`';
			$this->context->smarty->assign('id_shop', $id_shop);
		} else {
			$sql = 'SELECT c.`id_block` AS id, cl.`content` AS content, cl.`link` AS link
			FROM `'._DB_PREFIX_.'customblocks` c
			JOIN `'._DB_PREFIX_.'customblocks_lang` cl ON (c.`id_block` = cl.`id_block` AND cl.`id_lang` = '.(int)$this->context->cookie->id_lang.')
			WHERE `inhook` = "topColumn"
			AND `active` = 1
			ORDER BY `position`';
		}
		$blocks = Db::getInstance()->ExecuteS($sql);
		$this->context->smarty->assign(array(
			'ps_version' => _PS_VERSION_,
			'blocks' => $blocks,
			'inhook' => 'topColumn'
		));
		return $this->display(__FILE__, 'views/templates/front/customblocks.tpl');
	}
}
